/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datasync.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.datasync.model.RecommendationsConfigMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Recommendation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Recommendation> {
    private static final SdkField<String> STORAGE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StorageType").getter(Recommendation.getter(Recommendation::storageType)).setter(Recommendation.setter(Builder::storageType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StorageType").build()}).build();
    private static final SdkField<Map<String, String>> STORAGE_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("StorageConfiguration").getter(Recommendation.getter(Recommendation::storageConfiguration)).setter(Recommendation.setter(Builder::storageConfiguration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StorageConfiguration").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> ESTIMATED_MONTHLY_STORAGE_COST_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EstimatedMonthlyStorageCost").getter(Recommendation.getter(Recommendation::estimatedMonthlyStorageCost)).setter(Recommendation.setter(Builder::estimatedMonthlyStorageCost)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EstimatedMonthlyStorageCost").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STORAGE_TYPE_FIELD, STORAGE_CONFIGURATION_FIELD, ESTIMATED_MONTHLY_STORAGE_COST_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("StorageType", STORAGE_TYPE_FIELD);
            this.put("StorageConfiguration", STORAGE_CONFIGURATION_FIELD);
            this.put("EstimatedMonthlyStorageCost", ESTIMATED_MONTHLY_STORAGE_COST_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String storageType;
    private final Map<String, String> storageConfiguration;
    private final String estimatedMonthlyStorageCost;

    private Recommendation(BuilderImpl builder) {
        this.storageType = builder.storageType;
        this.storageConfiguration = builder.storageConfiguration;
        this.estimatedMonthlyStorageCost = builder.estimatedMonthlyStorageCost;
    }

    public final String storageType() {
        return this.storageType;
    }

    public final boolean hasStorageConfiguration() {
        return this.storageConfiguration != null && !(this.storageConfiguration instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> storageConfiguration() {
        return this.storageConfiguration;
    }

    public final String estimatedMonthlyStorageCost() {
        return this.estimatedMonthlyStorageCost;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.storageType());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStorageConfiguration() ? this.storageConfiguration() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.estimatedMonthlyStorageCost());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Recommendation)) {
            return false;
        }
        Recommendation other = (Recommendation)obj;
        return Objects.equals(this.storageType(), other.storageType()) && this.hasStorageConfiguration() == other.hasStorageConfiguration() && Objects.equals(this.storageConfiguration(), other.storageConfiguration()) && Objects.equals(this.estimatedMonthlyStorageCost(), other.estimatedMonthlyStorageCost());
    }

    public final String toString() {
        return ToString.builder((String)"Recommendation").add("StorageType", (Object)this.storageType()).add("StorageConfiguration", this.hasStorageConfiguration() ? this.storageConfiguration() : null).add("EstimatedMonthlyStorageCost", (Object)this.estimatedMonthlyStorageCost()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StorageType": {
                return Optional.ofNullable(clazz.cast(this.storageType()));
            }
            case "StorageConfiguration": {
                return Optional.ofNullable(clazz.cast(this.storageConfiguration()));
            }
            case "EstimatedMonthlyStorageCost": {
                return Optional.ofNullable(clazz.cast(this.estimatedMonthlyStorageCost()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<Recommendation, T> g) {
        return obj -> g.apply((Recommendation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String storageType;
        private Map<String, String> storageConfiguration = DefaultSdkAutoConstructMap.getInstance();
        private String estimatedMonthlyStorageCost;

        private BuilderImpl() {
        }

        private BuilderImpl(Recommendation model) {
            this.storageType(model.storageType);
            this.storageConfiguration(model.storageConfiguration);
            this.estimatedMonthlyStorageCost(model.estimatedMonthlyStorageCost);
        }

        public final String getStorageType() {
            return this.storageType;
        }

        public final void setStorageType(String storageType) {
            this.storageType = storageType;
        }

        @Override
        public final Builder storageType(String storageType) {
            this.storageType = storageType;
            return this;
        }

        public final Map<String, String> getStorageConfiguration() {
            if (this.storageConfiguration instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.storageConfiguration;
        }

        public final void setStorageConfiguration(Map<String, String> storageConfiguration) {
            this.storageConfiguration = RecommendationsConfigMapCopier.copy(storageConfiguration);
        }

        @Override
        public final Builder storageConfiguration(Map<String, String> storageConfiguration) {
            this.storageConfiguration = RecommendationsConfigMapCopier.copy(storageConfiguration);
            return this;
        }

        public final String getEstimatedMonthlyStorageCost() {
            return this.estimatedMonthlyStorageCost;
        }

        public final void setEstimatedMonthlyStorageCost(String estimatedMonthlyStorageCost) {
            this.estimatedMonthlyStorageCost = estimatedMonthlyStorageCost;
        }

        @Override
        public final Builder estimatedMonthlyStorageCost(String estimatedMonthlyStorageCost) {
            this.estimatedMonthlyStorageCost = estimatedMonthlyStorageCost;
            return this;
        }

        public Recommendation build() {
            return new Recommendation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Recommendation> {
        public Builder storageType(String var1);

        public Builder storageConfiguration(Map<String, String> var1);

        public Builder estimatedMonthlyStorageCost(String var1);
    }
}

