/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datasync.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.datasync.model.DataSyncRequest;
import software.amazon.awssdk.services.datasync.model.FsxUpdateProtocol;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateLocationFsxOntapRequest
extends DataSyncRequest
implements ToCopyableBuilder<Builder, UpdateLocationFsxOntapRequest> {
    private static final SdkField<String> LOCATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LocationArn").getter(UpdateLocationFsxOntapRequest.getter(UpdateLocationFsxOntapRequest::locationArn)).setter(UpdateLocationFsxOntapRequest.setter(Builder::locationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocationArn").build()}).build();
    private static final SdkField<FsxUpdateProtocol> PROTOCOL_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Protocol").getter(UpdateLocationFsxOntapRequest.getter(UpdateLocationFsxOntapRequest::protocol)).setter(UpdateLocationFsxOntapRequest.setter(Builder::protocol)).constructor(FsxUpdateProtocol::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Protocol").build()}).build();
    private static final SdkField<String> SUBDIRECTORY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Subdirectory").getter(UpdateLocationFsxOntapRequest.getter(UpdateLocationFsxOntapRequest::subdirectory)).setter(UpdateLocationFsxOntapRequest.setter(Builder::subdirectory)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Subdirectory").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOCATION_ARN_FIELD, PROTOCOL_FIELD, SUBDIRECTORY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateLocationFsxOntapRequest.memberNameToFieldInitializer();
    private final String locationArn;
    private final FsxUpdateProtocol protocol;
    private final String subdirectory;

    private UpdateLocationFsxOntapRequest(BuilderImpl builder) {
        super(builder);
        this.locationArn = builder.locationArn;
        this.protocol = builder.protocol;
        this.subdirectory = builder.subdirectory;
    }

    public final String locationArn() {
        return this.locationArn;
    }

    public final FsxUpdateProtocol protocol() {
        return this.protocol;
    }

    public final String subdirectory() {
        return this.subdirectory;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.locationArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.protocol());
        hashCode = 31 * hashCode + Objects.hashCode(this.subdirectory());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateLocationFsxOntapRequest)) {
            return false;
        }
        UpdateLocationFsxOntapRequest other = (UpdateLocationFsxOntapRequest)((Object)obj);
        return Objects.equals(this.locationArn(), other.locationArn()) && Objects.equals(this.protocol(), other.protocol()) && Objects.equals(this.subdirectory(), other.subdirectory());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateLocationFsxOntapRequest").add("LocationArn", (Object)this.locationArn()).add("Protocol", (Object)this.protocol()).add("Subdirectory", (Object)this.subdirectory()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LocationArn": {
                return Optional.ofNullable(clazz.cast(this.locationArn()));
            }
            case "Protocol": {
                return Optional.ofNullable(clazz.cast(this.protocol()));
            }
            case "Subdirectory": {
                return Optional.ofNullable(clazz.cast(this.subdirectory()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("LocationArn", LOCATION_ARN_FIELD);
        map.put("Protocol", PROTOCOL_FIELD);
        map.put("Subdirectory", SUBDIRECTORY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateLocationFsxOntapRequest, T> g) {
        return obj -> g.apply((UpdateLocationFsxOntapRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DataSyncRequest.BuilderImpl
    implements Builder {
        private String locationArn;
        private FsxUpdateProtocol protocol;
        private String subdirectory;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateLocationFsxOntapRequest model) {
            super(model);
            this.locationArn(model.locationArn);
            this.protocol(model.protocol);
            this.subdirectory(model.subdirectory);
        }

        public final String getLocationArn() {
            return this.locationArn;
        }

        public final void setLocationArn(String locationArn) {
            this.locationArn = locationArn;
        }

        @Override
        public final Builder locationArn(String locationArn) {
            this.locationArn = locationArn;
            return this;
        }

        public final FsxUpdateProtocol.Builder getProtocol() {
            return this.protocol != null ? this.protocol.toBuilder() : null;
        }

        public final void setProtocol(FsxUpdateProtocol.BuilderImpl protocol) {
            this.protocol = protocol != null ? protocol.build() : null;
        }

        @Override
        public final Builder protocol(FsxUpdateProtocol protocol) {
            this.protocol = protocol;
            return this;
        }

        public final String getSubdirectory() {
            return this.subdirectory;
        }

        public final void setSubdirectory(String subdirectory) {
            this.subdirectory = subdirectory;
        }

        @Override
        public final Builder subdirectory(String subdirectory) {
            this.subdirectory = subdirectory;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateLocationFsxOntapRequest build() {
            return new UpdateLocationFsxOntapRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends DataSyncRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateLocationFsxOntapRequest> {
        public Builder locationArn(String var1);

        public Builder protocol(FsxUpdateProtocol var1);

        default public Builder protocol(Consumer<FsxUpdateProtocol.Builder> protocol) {
            return this.protocol((FsxUpdateProtocol)((FsxUpdateProtocol.Builder)FsxUpdateProtocol.builder().applyMutation(protocol)).build());
        }

        public Builder subdirectory(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

