/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datasync.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.datasync.model.ScheduleDisabledBy;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TaskScheduleDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TaskScheduleDetails> {
    private static final SdkField<Instant> STATUS_UPDATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("StatusUpdateTime").getter(TaskScheduleDetails.getter(TaskScheduleDetails::statusUpdateTime)).setter(TaskScheduleDetails.setter(Builder::statusUpdateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusUpdateTime").build()}).build();
    private static final SdkField<String> DISABLED_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DisabledReason").getter(TaskScheduleDetails.getter(TaskScheduleDetails::disabledReason)).setter(TaskScheduleDetails.setter(Builder::disabledReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisabledReason").build()}).build();
    private static final SdkField<String> DISABLED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DisabledBy").getter(TaskScheduleDetails.getter(TaskScheduleDetails::disabledByAsString)).setter(TaskScheduleDetails.setter(Builder::disabledBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisabledBy").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_UPDATE_TIME_FIELD, DISABLED_REASON_FIELD, DISABLED_BY_FIELD));
    private static final long serialVersionUID = 1L;
    private final Instant statusUpdateTime;
    private final String disabledReason;
    private final String disabledBy;

    private TaskScheduleDetails(BuilderImpl builder) {
        this.statusUpdateTime = builder.statusUpdateTime;
        this.disabledReason = builder.disabledReason;
        this.disabledBy = builder.disabledBy;
    }

    public final Instant statusUpdateTime() {
        return this.statusUpdateTime;
    }

    public final String disabledReason() {
        return this.disabledReason;
    }

    public final ScheduleDisabledBy disabledBy() {
        return ScheduleDisabledBy.fromValue(this.disabledBy);
    }

    public final String disabledByAsString() {
        return this.disabledBy;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.statusUpdateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.disabledReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.disabledByAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TaskScheduleDetails)) {
            return false;
        }
        TaskScheduleDetails other = (TaskScheduleDetails)obj;
        return Objects.equals(this.statusUpdateTime(), other.statusUpdateTime()) && Objects.equals(this.disabledReason(), other.disabledReason()) && Objects.equals(this.disabledByAsString(), other.disabledByAsString());
    }

    public final String toString() {
        return ToString.builder((String)"TaskScheduleDetails").add("StatusUpdateTime", (Object)this.statusUpdateTime()).add("DisabledReason", (Object)this.disabledReason()).add("DisabledBy", (Object)this.disabledByAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StatusUpdateTime": {
                return Optional.ofNullable(clazz.cast(this.statusUpdateTime()));
            }
            case "DisabledReason": {
                return Optional.ofNullable(clazz.cast(this.disabledReason()));
            }
            case "DisabledBy": {
                return Optional.ofNullable(clazz.cast(this.disabledByAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TaskScheduleDetails, T> g) {
        return obj -> g.apply((TaskScheduleDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Instant statusUpdateTime;
        private String disabledReason;
        private String disabledBy;

        private BuilderImpl() {
        }

        private BuilderImpl(TaskScheduleDetails model) {
            this.statusUpdateTime(model.statusUpdateTime);
            this.disabledReason(model.disabledReason);
            this.disabledBy(model.disabledBy);
        }

        public final Instant getStatusUpdateTime() {
            return this.statusUpdateTime;
        }

        public final void setStatusUpdateTime(Instant statusUpdateTime) {
            this.statusUpdateTime = statusUpdateTime;
        }

        @Override
        public final Builder statusUpdateTime(Instant statusUpdateTime) {
            this.statusUpdateTime = statusUpdateTime;
            return this;
        }

        public final String getDisabledReason() {
            return this.disabledReason;
        }

        public final void setDisabledReason(String disabledReason) {
            this.disabledReason = disabledReason;
        }

        @Override
        public final Builder disabledReason(String disabledReason) {
            this.disabledReason = disabledReason;
            return this;
        }

        public final String getDisabledBy() {
            return this.disabledBy;
        }

        public final void setDisabledBy(String disabledBy) {
            this.disabledBy = disabledBy;
        }

        @Override
        public final Builder disabledBy(String disabledBy) {
            this.disabledBy = disabledBy;
            return this;
        }

        @Override
        public final Builder disabledBy(ScheduleDisabledBy disabledBy) {
            this.disabledBy(disabledBy == null ? null : disabledBy.toString());
            return this;
        }

        public TaskScheduleDetails build() {
            return new TaskScheduleDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TaskScheduleDetails> {
        public Builder statusUpdateTime(Instant var1);

        public Builder disabledReason(String var1);

        public Builder disabledBy(String var1);

        public Builder disabledBy(ScheduleDisabledBy var1);
    }
}

