/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datasync.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum NfsVersion {
    AUTOMATIC("AUTOMATIC"),
    NFS3("NFS3"),
    NFS4_0("NFS4_0"),
    NFS4_1("NFS4_1"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, NfsVersion> VALUE_MAP;
    private final String value;

    private NfsVersion(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static NfsVersion fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<NfsVersion> knownValues() {
        EnumSet<NfsVersion> knownValues = EnumSet.allOf(NfsVersion.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(NfsVersion.class, NfsVersion::toString);
    }
}

