/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datasync.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum Operator {
    EQUALS("Equals"),
    NOT_EQUALS("NotEquals"),
    IN("In"),
    LESS_THAN_OR_EQUAL("LessThanOrEqual"),
    LESS_THAN("LessThan"),
    GREATER_THAN_OR_EQUAL("GreaterThanOrEqual"),
    GREATER_THAN("GreaterThan"),
    CONTAINS("Contains"),
    NOT_CONTAINS("NotContains"),
    BEGINS_WITH("BeginsWith"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private Operator(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static Operator fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(Operator.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<Operator> knownValues() {
        return Stream.of(Operator.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

