/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datasync.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.datasync.model.DataSyncRequest;
import software.amazon.awssdk.services.datasync.model.FilterListCopier;
import software.amazon.awssdk.services.datasync.model.FilterRule;
import software.amazon.awssdk.services.datasync.model.InputTagListCopier;
import software.amazon.awssdk.services.datasync.model.Options;
import software.amazon.awssdk.services.datasync.model.TagListEntry;
import software.amazon.awssdk.services.datasync.model.TaskSchedule;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateTaskRequest
extends DataSyncRequest
implements ToCopyableBuilder<Builder, CreateTaskRequest> {
    private static final SdkField<String> SOURCE_LOCATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateTaskRequest.getter(CreateTaskRequest::sourceLocationArn)).setter(CreateTaskRequest.setter(Builder::sourceLocationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceLocationArn").build()}).build();
    private static final SdkField<String> DESTINATION_LOCATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateTaskRequest.getter(CreateTaskRequest::destinationLocationArn)).setter(CreateTaskRequest.setter(Builder::destinationLocationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationLocationArn").build()}).build();
    private static final SdkField<String> CLOUD_WATCH_LOG_GROUP_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateTaskRequest.getter(CreateTaskRequest::cloudWatchLogGroupArn)).setter(CreateTaskRequest.setter(Builder::cloudWatchLogGroupArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CloudWatchLogGroupArn").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateTaskRequest.getter(CreateTaskRequest::name)).setter(CreateTaskRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<Options> OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(CreateTaskRequest.getter(CreateTaskRequest::options)).setter(CreateTaskRequest.setter(Builder::options)).constructor(Options::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Options").build()}).build();
    private static final SdkField<List<FilterRule>> EXCLUDES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(CreateTaskRequest.getter(CreateTaskRequest::excludes)).setter(CreateTaskRequest.setter(Builder::excludes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Excludes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FilterRule::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<TaskSchedule> SCHEDULE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(CreateTaskRequest.getter(CreateTaskRequest::schedule)).setter(CreateTaskRequest.setter(Builder::schedule)).constructor(TaskSchedule::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Schedule").build()}).build();
    private static final SdkField<List<TagListEntry>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(CreateTaskRequest.getter(CreateTaskRequest::tags)).setter(CreateTaskRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TagListEntry::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_LOCATION_ARN_FIELD, DESTINATION_LOCATION_ARN_FIELD, CLOUD_WATCH_LOG_GROUP_ARN_FIELD, NAME_FIELD, OPTIONS_FIELD, EXCLUDES_FIELD, SCHEDULE_FIELD, TAGS_FIELD));
    private final String sourceLocationArn;
    private final String destinationLocationArn;
    private final String cloudWatchLogGroupArn;
    private final String name;
    private final Options options;
    private final List<FilterRule> excludes;
    private final TaskSchedule schedule;
    private final List<TagListEntry> tags;

    private CreateTaskRequest(BuilderImpl builder) {
        super(builder);
        this.sourceLocationArn = builder.sourceLocationArn;
        this.destinationLocationArn = builder.destinationLocationArn;
        this.cloudWatchLogGroupArn = builder.cloudWatchLogGroupArn;
        this.name = builder.name;
        this.options = builder.options;
        this.excludes = builder.excludes;
        this.schedule = builder.schedule;
        this.tags = builder.tags;
    }

    public String sourceLocationArn() {
        return this.sourceLocationArn;
    }

    public String destinationLocationArn() {
        return this.destinationLocationArn;
    }

    public String cloudWatchLogGroupArn() {
        return this.cloudWatchLogGroupArn;
    }

    public String name() {
        return this.name;
    }

    public Options options() {
        return this.options;
    }

    public boolean hasExcludes() {
        return this.excludes != null && !(this.excludes instanceof SdkAutoConstructList);
    }

    public List<FilterRule> excludes() {
        return this.excludes;
    }

    public TaskSchedule schedule() {
        return this.schedule;
    }

    public boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public List<TagListEntry> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceLocationArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationLocationArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.cloudWatchLogGroupArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.options());
        hashCode = 31 * hashCode + Objects.hashCode(this.excludes());
        hashCode = 31 * hashCode + Objects.hashCode(this.schedule());
        hashCode = 31 * hashCode + Objects.hashCode(this.tags());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateTaskRequest)) {
            return false;
        }
        CreateTaskRequest other = (CreateTaskRequest)((Object)obj);
        return Objects.equals(this.sourceLocationArn(), other.sourceLocationArn()) && Objects.equals(this.destinationLocationArn(), other.destinationLocationArn()) && Objects.equals(this.cloudWatchLogGroupArn(), other.cloudWatchLogGroupArn()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.options(), other.options()) && Objects.equals(this.excludes(), other.excludes()) && Objects.equals(this.schedule(), other.schedule()) && Objects.equals(this.tags(), other.tags());
    }

    public String toString() {
        return ToString.builder((String)"CreateTaskRequest").add("SourceLocationArn", (Object)this.sourceLocationArn()).add("DestinationLocationArn", (Object)this.destinationLocationArn()).add("CloudWatchLogGroupArn", (Object)this.cloudWatchLogGroupArn()).add("Name", (Object)this.name()).add("Options", (Object)this.options()).add("Excludes", this.excludes()).add("Schedule", (Object)this.schedule()).add("Tags", this.tags()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SourceLocationArn": {
                return Optional.ofNullable(clazz.cast(this.sourceLocationArn()));
            }
            case "DestinationLocationArn": {
                return Optional.ofNullable(clazz.cast(this.destinationLocationArn()));
            }
            case "CloudWatchLogGroupArn": {
                return Optional.ofNullable(clazz.cast(this.cloudWatchLogGroupArn()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Options": {
                return Optional.ofNullable(clazz.cast(this.options()));
            }
            case "Excludes": {
                return Optional.ofNullable(clazz.cast(this.excludes()));
            }
            case "Schedule": {
                return Optional.ofNullable(clazz.cast(this.schedule()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateTaskRequest, T> g) {
        return obj -> g.apply((CreateTaskRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DataSyncRequest.BuilderImpl
    implements Builder {
        private String sourceLocationArn;
        private String destinationLocationArn;
        private String cloudWatchLogGroupArn;
        private String name;
        private Options options;
        private List<FilterRule> excludes = DefaultSdkAutoConstructList.getInstance();
        private TaskSchedule schedule;
        private List<TagListEntry> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateTaskRequest model) {
            super(model);
            this.sourceLocationArn(model.sourceLocationArn);
            this.destinationLocationArn(model.destinationLocationArn);
            this.cloudWatchLogGroupArn(model.cloudWatchLogGroupArn);
            this.name(model.name);
            this.options(model.options);
            this.excludes(model.excludes);
            this.schedule(model.schedule);
            this.tags(model.tags);
        }

        public final String getSourceLocationArn() {
            return this.sourceLocationArn;
        }

        @Override
        public final Builder sourceLocationArn(String sourceLocationArn) {
            this.sourceLocationArn = sourceLocationArn;
            return this;
        }

        public final void setSourceLocationArn(String sourceLocationArn) {
            this.sourceLocationArn = sourceLocationArn;
        }

        public final String getDestinationLocationArn() {
            return this.destinationLocationArn;
        }

        @Override
        public final Builder destinationLocationArn(String destinationLocationArn) {
            this.destinationLocationArn = destinationLocationArn;
            return this;
        }

        public final void setDestinationLocationArn(String destinationLocationArn) {
            this.destinationLocationArn = destinationLocationArn;
        }

        public final String getCloudWatchLogGroupArn() {
            return this.cloudWatchLogGroupArn;
        }

        @Override
        public final Builder cloudWatchLogGroupArn(String cloudWatchLogGroupArn) {
            this.cloudWatchLogGroupArn = cloudWatchLogGroupArn;
            return this;
        }

        public final void setCloudWatchLogGroupArn(String cloudWatchLogGroupArn) {
            this.cloudWatchLogGroupArn = cloudWatchLogGroupArn;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Options.Builder getOptions() {
            return this.options != null ? this.options.toBuilder() : null;
        }

        @Override
        public final Builder options(Options options) {
            this.options = options;
            return this;
        }

        public final void setOptions(Options.BuilderImpl options) {
            this.options = options != null ? options.build() : null;
        }

        public final Collection<FilterRule.Builder> getExcludes() {
            return this.excludes != null ? (Collection)this.excludes.stream().map(FilterRule::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder excludes(Collection<FilterRule> excludes) {
            this.excludes = FilterListCopier.copy(excludes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder excludes(FilterRule ... excludes) {
            this.excludes(Arrays.asList(excludes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder excludes(Consumer<FilterRule.Builder> ... excludes) {
            this.excludes(Stream.of(excludes).map(c -> (FilterRule)((FilterRule.Builder)FilterRule.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setExcludes(Collection<FilterRule.BuilderImpl> excludes) {
            this.excludes = FilterListCopier.copyFromBuilder(excludes);
        }

        public final TaskSchedule.Builder getSchedule() {
            return this.schedule != null ? this.schedule.toBuilder() : null;
        }

        @Override
        public final Builder schedule(TaskSchedule schedule) {
            this.schedule = schedule;
            return this;
        }

        public final void setSchedule(TaskSchedule.BuilderImpl schedule) {
            this.schedule = schedule != null ? schedule.build() : null;
        }

        public final Collection<TagListEntry.Builder> getTags() {
            return this.tags != null ? (Collection)this.tags.stream().map(TagListEntry::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<TagListEntry> tags) {
            this.tags = InputTagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(TagListEntry ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<TagListEntry.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (TagListEntry)((TagListEntry.Builder)TagListEntry.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<TagListEntry.BuilderImpl> tags) {
            this.tags = InputTagListCopier.copyFromBuilder(tags);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateTaskRequest build() {
            return new CreateTaskRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends DataSyncRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateTaskRequest> {
        public Builder sourceLocationArn(String var1);

        public Builder destinationLocationArn(String var1);

        public Builder cloudWatchLogGroupArn(String var1);

        public Builder name(String var1);

        public Builder options(Options var1);

        default public Builder options(Consumer<Options.Builder> options) {
            return this.options((Options)((Options.Builder)Options.builder().applyMutation(options)).build());
        }

        public Builder excludes(Collection<FilterRule> var1);

        public Builder excludes(FilterRule ... var1);

        public Builder excludes(Consumer<FilterRule.Builder> ... var1);

        public Builder schedule(TaskSchedule var1);

        default public Builder schedule(Consumer<TaskSchedule.Builder> schedule) {
            return this.schedule((TaskSchedule)((TaskSchedule.Builder)TaskSchedule.builder().applyMutation(schedule)).build());
        }

        public Builder tags(Collection<TagListEntry> var1);

        public Builder tags(TagListEntry ... var1);

        public Builder tags(Consumer<TagListEntry.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

