/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datasync.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.datasync.model.DataSyncResponse;
import software.amazon.awssdk.services.datasync.model.DestinationNetworkInterfaceArnsCopier;
import software.amazon.awssdk.services.datasync.model.FilterListCopier;
import software.amazon.awssdk.services.datasync.model.FilterRule;
import software.amazon.awssdk.services.datasync.model.Options;
import software.amazon.awssdk.services.datasync.model.SourceNetworkInterfaceArnsCopier;
import software.amazon.awssdk.services.datasync.model.TaskSchedule;
import software.amazon.awssdk.services.datasync.model.TaskStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeTaskResponse
extends DataSyncResponse
implements ToCopyableBuilder<Builder, DescribeTaskResponse> {
    private static final SdkField<String> TASK_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeTaskResponse.getter(DescribeTaskResponse::taskArn)).setter(DescribeTaskResponse.setter(Builder::taskArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TaskArn").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeTaskResponse.getter(DescribeTaskResponse::statusAsString)).setter(DescribeTaskResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeTaskResponse.getter(DescribeTaskResponse::name)).setter(DescribeTaskResponse.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> CURRENT_TASK_EXECUTION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeTaskResponse.getter(DescribeTaskResponse::currentTaskExecutionArn)).setter(DescribeTaskResponse.setter(Builder::currentTaskExecutionArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrentTaskExecutionArn").build()}).build();
    private static final SdkField<String> SOURCE_LOCATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeTaskResponse.getter(DescribeTaskResponse::sourceLocationArn)).setter(DescribeTaskResponse.setter(Builder::sourceLocationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceLocationArn").build()}).build();
    private static final SdkField<String> DESTINATION_LOCATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeTaskResponse.getter(DescribeTaskResponse::destinationLocationArn)).setter(DescribeTaskResponse.setter(Builder::destinationLocationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationLocationArn").build()}).build();
    private static final SdkField<String> CLOUD_WATCH_LOG_GROUP_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeTaskResponse.getter(DescribeTaskResponse::cloudWatchLogGroupArn)).setter(DescribeTaskResponse.setter(Builder::cloudWatchLogGroupArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CloudWatchLogGroupArn").build()}).build();
    private static final SdkField<List<String>> SOURCE_NETWORK_INTERFACE_ARNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(DescribeTaskResponse.getter(DescribeTaskResponse::sourceNetworkInterfaceArns)).setter(DescribeTaskResponse.setter(Builder::sourceNetworkInterfaceArns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceNetworkInterfaceArns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> DESTINATION_NETWORK_INTERFACE_ARNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(DescribeTaskResponse.getter(DescribeTaskResponse::destinationNetworkInterfaceArns)).setter(DescribeTaskResponse.setter(Builder::destinationNetworkInterfaceArns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationNetworkInterfaceArns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Options> OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(DescribeTaskResponse.getter(DescribeTaskResponse::options)).setter(DescribeTaskResponse.setter(Builder::options)).constructor(Options::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Options").build()}).build();
    private static final SdkField<List<FilterRule>> EXCLUDES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(DescribeTaskResponse.getter(DescribeTaskResponse::excludes)).setter(DescribeTaskResponse.setter(Builder::excludes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Excludes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FilterRule::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<TaskSchedule> SCHEDULE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(DescribeTaskResponse.getter(DescribeTaskResponse::schedule)).setter(DescribeTaskResponse.setter(Builder::schedule)).constructor(TaskSchedule::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Schedule").build()}).build();
    private static final SdkField<String> ERROR_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeTaskResponse.getter(DescribeTaskResponse::errorCode)).setter(DescribeTaskResponse.setter(Builder::errorCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorCode").build()}).build();
    private static final SdkField<String> ERROR_DETAIL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeTaskResponse.getter(DescribeTaskResponse::errorDetail)).setter(DescribeTaskResponse.setter(Builder::errorDetail)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorDetail").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(DescribeTaskResponse.getter(DescribeTaskResponse::creationTime)).setter(DescribeTaskResponse.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TASK_ARN_FIELD, STATUS_FIELD, NAME_FIELD, CURRENT_TASK_EXECUTION_ARN_FIELD, SOURCE_LOCATION_ARN_FIELD, DESTINATION_LOCATION_ARN_FIELD, CLOUD_WATCH_LOG_GROUP_ARN_FIELD, SOURCE_NETWORK_INTERFACE_ARNS_FIELD, DESTINATION_NETWORK_INTERFACE_ARNS_FIELD, OPTIONS_FIELD, EXCLUDES_FIELD, SCHEDULE_FIELD, ERROR_CODE_FIELD, ERROR_DETAIL_FIELD, CREATION_TIME_FIELD));
    private final String taskArn;
    private final String status;
    private final String name;
    private final String currentTaskExecutionArn;
    private final String sourceLocationArn;
    private final String destinationLocationArn;
    private final String cloudWatchLogGroupArn;
    private final List<String> sourceNetworkInterfaceArns;
    private final List<String> destinationNetworkInterfaceArns;
    private final Options options;
    private final List<FilterRule> excludes;
    private final TaskSchedule schedule;
    private final String errorCode;
    private final String errorDetail;
    private final Instant creationTime;

    private DescribeTaskResponse(BuilderImpl builder) {
        super(builder);
        this.taskArn = builder.taskArn;
        this.status = builder.status;
        this.name = builder.name;
        this.currentTaskExecutionArn = builder.currentTaskExecutionArn;
        this.sourceLocationArn = builder.sourceLocationArn;
        this.destinationLocationArn = builder.destinationLocationArn;
        this.cloudWatchLogGroupArn = builder.cloudWatchLogGroupArn;
        this.sourceNetworkInterfaceArns = builder.sourceNetworkInterfaceArns;
        this.destinationNetworkInterfaceArns = builder.destinationNetworkInterfaceArns;
        this.options = builder.options;
        this.excludes = builder.excludes;
        this.schedule = builder.schedule;
        this.errorCode = builder.errorCode;
        this.errorDetail = builder.errorDetail;
        this.creationTime = builder.creationTime;
    }

    public String taskArn() {
        return this.taskArn;
    }

    public TaskStatus status() {
        return TaskStatus.fromValue(this.status);
    }

    public String statusAsString() {
        return this.status;
    }

    public String name() {
        return this.name;
    }

    public String currentTaskExecutionArn() {
        return this.currentTaskExecutionArn;
    }

    public String sourceLocationArn() {
        return this.sourceLocationArn;
    }

    public String destinationLocationArn() {
        return this.destinationLocationArn;
    }

    public String cloudWatchLogGroupArn() {
        return this.cloudWatchLogGroupArn;
    }

    public boolean hasSourceNetworkInterfaceArns() {
        return this.sourceNetworkInterfaceArns != null && !(this.sourceNetworkInterfaceArns instanceof SdkAutoConstructList);
    }

    public List<String> sourceNetworkInterfaceArns() {
        return this.sourceNetworkInterfaceArns;
    }

    public boolean hasDestinationNetworkInterfaceArns() {
        return this.destinationNetworkInterfaceArns != null && !(this.destinationNetworkInterfaceArns instanceof SdkAutoConstructList);
    }

    public List<String> destinationNetworkInterfaceArns() {
        return this.destinationNetworkInterfaceArns;
    }

    public Options options() {
        return this.options;
    }

    public boolean hasExcludes() {
        return this.excludes != null && !(this.excludes instanceof SdkAutoConstructList);
    }

    public List<FilterRule> excludes() {
        return this.excludes;
    }

    public TaskSchedule schedule() {
        return this.schedule;
    }

    public String errorCode() {
        return this.errorCode;
    }

    public String errorDetail() {
        return this.errorDetail;
    }

    public Instant creationTime() {
        return this.creationTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.taskArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.currentTaskExecutionArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceLocationArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationLocationArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.cloudWatchLogGroupArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceNetworkInterfaceArns());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationNetworkInterfaceArns());
        hashCode = 31 * hashCode + Objects.hashCode(this.options());
        hashCode = 31 * hashCode + Objects.hashCode(this.excludes());
        hashCode = 31 * hashCode + Objects.hashCode(this.schedule());
        hashCode = 31 * hashCode + Objects.hashCode(this.errorCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.errorDetail());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeTaskResponse)) {
            return false;
        }
        DescribeTaskResponse other = (DescribeTaskResponse)((Object)obj);
        return Objects.equals(this.taskArn(), other.taskArn()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.currentTaskExecutionArn(), other.currentTaskExecutionArn()) && Objects.equals(this.sourceLocationArn(), other.sourceLocationArn()) && Objects.equals(this.destinationLocationArn(), other.destinationLocationArn()) && Objects.equals(this.cloudWatchLogGroupArn(), other.cloudWatchLogGroupArn()) && Objects.equals(this.sourceNetworkInterfaceArns(), other.sourceNetworkInterfaceArns()) && Objects.equals(this.destinationNetworkInterfaceArns(), other.destinationNetworkInterfaceArns()) && Objects.equals(this.options(), other.options()) && Objects.equals(this.excludes(), other.excludes()) && Objects.equals(this.schedule(), other.schedule()) && Objects.equals(this.errorCode(), other.errorCode()) && Objects.equals(this.errorDetail(), other.errorDetail()) && Objects.equals(this.creationTime(), other.creationTime());
    }

    public String toString() {
        return ToString.builder((String)"DescribeTaskResponse").add("TaskArn", (Object)this.taskArn()).add("Status", (Object)this.statusAsString()).add("Name", (Object)this.name()).add("CurrentTaskExecutionArn", (Object)this.currentTaskExecutionArn()).add("SourceLocationArn", (Object)this.sourceLocationArn()).add("DestinationLocationArn", (Object)this.destinationLocationArn()).add("CloudWatchLogGroupArn", (Object)this.cloudWatchLogGroupArn()).add("SourceNetworkInterfaceArns", this.sourceNetworkInterfaceArns()).add("DestinationNetworkInterfaceArns", this.destinationNetworkInterfaceArns()).add("Options", (Object)this.options()).add("Excludes", this.excludes()).add("Schedule", (Object)this.schedule()).add("ErrorCode", (Object)this.errorCode()).add("ErrorDetail", (Object)this.errorDetail()).add("CreationTime", (Object)this.creationTime()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TaskArn": {
                return Optional.ofNullable(clazz.cast(this.taskArn()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "CurrentTaskExecutionArn": {
                return Optional.ofNullable(clazz.cast(this.currentTaskExecutionArn()));
            }
            case "SourceLocationArn": {
                return Optional.ofNullable(clazz.cast(this.sourceLocationArn()));
            }
            case "DestinationLocationArn": {
                return Optional.ofNullable(clazz.cast(this.destinationLocationArn()));
            }
            case "CloudWatchLogGroupArn": {
                return Optional.ofNullable(clazz.cast(this.cloudWatchLogGroupArn()));
            }
            case "SourceNetworkInterfaceArns": {
                return Optional.ofNullable(clazz.cast(this.sourceNetworkInterfaceArns()));
            }
            case "DestinationNetworkInterfaceArns": {
                return Optional.ofNullable(clazz.cast(this.destinationNetworkInterfaceArns()));
            }
            case "Options": {
                return Optional.ofNullable(clazz.cast(this.options()));
            }
            case "Excludes": {
                return Optional.ofNullable(clazz.cast(this.excludes()));
            }
            case "Schedule": {
                return Optional.ofNullable(clazz.cast(this.schedule()));
            }
            case "ErrorCode": {
                return Optional.ofNullable(clazz.cast(this.errorCode()));
            }
            case "ErrorDetail": {
                return Optional.ofNullable(clazz.cast(this.errorDetail()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeTaskResponse, T> g) {
        return obj -> g.apply((DescribeTaskResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DataSyncResponse.BuilderImpl
    implements Builder {
        private String taskArn;
        private String status;
        private String name;
        private String currentTaskExecutionArn;
        private String sourceLocationArn;
        private String destinationLocationArn;
        private String cloudWatchLogGroupArn;
        private List<String> sourceNetworkInterfaceArns = DefaultSdkAutoConstructList.getInstance();
        private List<String> destinationNetworkInterfaceArns = DefaultSdkAutoConstructList.getInstance();
        private Options options;
        private List<FilterRule> excludes = DefaultSdkAutoConstructList.getInstance();
        private TaskSchedule schedule;
        private String errorCode;
        private String errorDetail;
        private Instant creationTime;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeTaskResponse model) {
            super(model);
            this.taskArn(model.taskArn);
            this.status(model.status);
            this.name(model.name);
            this.currentTaskExecutionArn(model.currentTaskExecutionArn);
            this.sourceLocationArn(model.sourceLocationArn);
            this.destinationLocationArn(model.destinationLocationArn);
            this.cloudWatchLogGroupArn(model.cloudWatchLogGroupArn);
            this.sourceNetworkInterfaceArns(model.sourceNetworkInterfaceArns);
            this.destinationNetworkInterfaceArns(model.destinationNetworkInterfaceArns);
            this.options(model.options);
            this.excludes(model.excludes);
            this.schedule(model.schedule);
            this.errorCode(model.errorCode);
            this.errorDetail(model.errorDetail);
            this.creationTime(model.creationTime);
        }

        public final String getTaskArn() {
            return this.taskArn;
        }

        @Override
        public final Builder taskArn(String taskArn) {
            this.taskArn = taskArn;
            return this;
        }

        public final void setTaskArn(String taskArn) {
            this.taskArn = taskArn;
        }

        public final String getStatusAsString() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(TaskStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getCurrentTaskExecutionArn() {
            return this.currentTaskExecutionArn;
        }

        @Override
        public final Builder currentTaskExecutionArn(String currentTaskExecutionArn) {
            this.currentTaskExecutionArn = currentTaskExecutionArn;
            return this;
        }

        public final void setCurrentTaskExecutionArn(String currentTaskExecutionArn) {
            this.currentTaskExecutionArn = currentTaskExecutionArn;
        }

        public final String getSourceLocationArn() {
            return this.sourceLocationArn;
        }

        @Override
        public final Builder sourceLocationArn(String sourceLocationArn) {
            this.sourceLocationArn = sourceLocationArn;
            return this;
        }

        public final void setSourceLocationArn(String sourceLocationArn) {
            this.sourceLocationArn = sourceLocationArn;
        }

        public final String getDestinationLocationArn() {
            return this.destinationLocationArn;
        }

        @Override
        public final Builder destinationLocationArn(String destinationLocationArn) {
            this.destinationLocationArn = destinationLocationArn;
            return this;
        }

        public final void setDestinationLocationArn(String destinationLocationArn) {
            this.destinationLocationArn = destinationLocationArn;
        }

        public final String getCloudWatchLogGroupArn() {
            return this.cloudWatchLogGroupArn;
        }

        @Override
        public final Builder cloudWatchLogGroupArn(String cloudWatchLogGroupArn) {
            this.cloudWatchLogGroupArn = cloudWatchLogGroupArn;
            return this;
        }

        public final void setCloudWatchLogGroupArn(String cloudWatchLogGroupArn) {
            this.cloudWatchLogGroupArn = cloudWatchLogGroupArn;
        }

        public final Collection<String> getSourceNetworkInterfaceArns() {
            return this.sourceNetworkInterfaceArns;
        }

        @Override
        public final Builder sourceNetworkInterfaceArns(Collection<String> sourceNetworkInterfaceArns) {
            this.sourceNetworkInterfaceArns = SourceNetworkInterfaceArnsCopier.copy(sourceNetworkInterfaceArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sourceNetworkInterfaceArns(String ... sourceNetworkInterfaceArns) {
            this.sourceNetworkInterfaceArns(Arrays.asList(sourceNetworkInterfaceArns));
            return this;
        }

        public final void setSourceNetworkInterfaceArns(Collection<String> sourceNetworkInterfaceArns) {
            this.sourceNetworkInterfaceArns = SourceNetworkInterfaceArnsCopier.copy(sourceNetworkInterfaceArns);
        }

        public final Collection<String> getDestinationNetworkInterfaceArns() {
            return this.destinationNetworkInterfaceArns;
        }

        @Override
        public final Builder destinationNetworkInterfaceArns(Collection<String> destinationNetworkInterfaceArns) {
            this.destinationNetworkInterfaceArns = DestinationNetworkInterfaceArnsCopier.copy(destinationNetworkInterfaceArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder destinationNetworkInterfaceArns(String ... destinationNetworkInterfaceArns) {
            this.destinationNetworkInterfaceArns(Arrays.asList(destinationNetworkInterfaceArns));
            return this;
        }

        public final void setDestinationNetworkInterfaceArns(Collection<String> destinationNetworkInterfaceArns) {
            this.destinationNetworkInterfaceArns = DestinationNetworkInterfaceArnsCopier.copy(destinationNetworkInterfaceArns);
        }

        public final Options.Builder getOptions() {
            return this.options != null ? this.options.toBuilder() : null;
        }

        @Override
        public final Builder options(Options options) {
            this.options = options;
            return this;
        }

        public final void setOptions(Options.BuilderImpl options) {
            this.options = options != null ? options.build() : null;
        }

        public final Collection<FilterRule.Builder> getExcludes() {
            return this.excludes != null ? (Collection)this.excludes.stream().map(FilterRule::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder excludes(Collection<FilterRule> excludes) {
            this.excludes = FilterListCopier.copy(excludes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder excludes(FilterRule ... excludes) {
            this.excludes(Arrays.asList(excludes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder excludes(Consumer<FilterRule.Builder> ... excludes) {
            this.excludes(Stream.of(excludes).map(c -> (FilterRule)((FilterRule.Builder)FilterRule.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setExcludes(Collection<FilterRule.BuilderImpl> excludes) {
            this.excludes = FilterListCopier.copyFromBuilder(excludes);
        }

        public final TaskSchedule.Builder getSchedule() {
            return this.schedule != null ? this.schedule.toBuilder() : null;
        }

        @Override
        public final Builder schedule(TaskSchedule schedule) {
            this.schedule = schedule;
            return this;
        }

        public final void setSchedule(TaskSchedule.BuilderImpl schedule) {
            this.schedule = schedule != null ? schedule.build() : null;
        }

        public final String getErrorCode() {
            return this.errorCode;
        }

        @Override
        public final Builder errorCode(String errorCode) {
            this.errorCode = errorCode;
            return this;
        }

        public final void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        public final String getErrorDetail() {
            return this.errorDetail;
        }

        @Override
        public final Builder errorDetail(String errorDetail) {
            this.errorDetail = errorDetail;
            return this;
        }

        public final void setErrorDetail(String errorDetail) {
            this.errorDetail = errorDetail;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public DescribeTaskResponse build() {
            return new DescribeTaskResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends DataSyncResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeTaskResponse> {
        public Builder taskArn(String var1);

        public Builder status(String var1);

        public Builder status(TaskStatus var1);

        public Builder name(String var1);

        public Builder currentTaskExecutionArn(String var1);

        public Builder sourceLocationArn(String var1);

        public Builder destinationLocationArn(String var1);

        public Builder cloudWatchLogGroupArn(String var1);

        public Builder sourceNetworkInterfaceArns(Collection<String> var1);

        public Builder sourceNetworkInterfaceArns(String ... var1);

        public Builder destinationNetworkInterfaceArns(Collection<String> var1);

        public Builder destinationNetworkInterfaceArns(String ... var1);

        public Builder options(Options var1);

        default public Builder options(Consumer<Options.Builder> options) {
            return this.options((Options)((Options.Builder)Options.builder().applyMutation(options)).build());
        }

        public Builder excludes(Collection<FilterRule> var1);

        public Builder excludes(FilterRule ... var1);

        public Builder excludes(Consumer<FilterRule.Builder> ... var1);

        public Builder schedule(TaskSchedule var1);

        default public Builder schedule(Consumer<TaskSchedule.Builder> schedule) {
            return this.schedule((TaskSchedule)((TaskSchedule.Builder)TaskSchedule.builder().applyMutation(schedule)).build());
        }

        public Builder errorCode(String var1);

        public Builder errorDetail(String var1);

        public Builder creationTime(Instant var1);
    }
}

