/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datapipeline.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the parameters for ReportTaskRunnerHeartbeat.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ReportTaskRunnerHeartbeatRequest extends DataPipelineRequest implements
        ToCopyableBuilder<ReportTaskRunnerHeartbeatRequest.Builder, ReportTaskRunnerHeartbeatRequest> {
    private static final SdkField<String> TASKRUNNER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("taskrunnerId").getter(getter(ReportTaskRunnerHeartbeatRequest::taskrunnerId))
            .setter(setter(Builder::taskrunnerId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskrunnerId").build()).build();

    private static final SdkField<String> WORKER_GROUP_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("workerGroup").getter(getter(ReportTaskRunnerHeartbeatRequest::workerGroup))
            .setter(setter(Builder::workerGroup))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workerGroup").build()).build();

    private static final SdkField<String> HOSTNAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("hostname").getter(getter(ReportTaskRunnerHeartbeatRequest::hostname)).setter(setter(Builder::hostname))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hostname").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TASKRUNNER_ID_FIELD,
            WORKER_GROUP_FIELD, HOSTNAME_FIELD));

    private final String taskrunnerId;

    private final String workerGroup;

    private final String hostname;

    private ReportTaskRunnerHeartbeatRequest(BuilderImpl builder) {
        super(builder);
        this.taskrunnerId = builder.taskrunnerId;
        this.workerGroup = builder.workerGroup;
        this.hostname = builder.hostname;
    }

    /**
     * <p>
     * The ID of the task runner. This value should be unique across your AWS account. In the case of AWS Data Pipeline
     * Task Runner launched on a resource managed by AWS Data Pipeline, the web service provides a unique identifier
     * when it launches the application. If you have written a custom task runner, you should assign a unique identifier
     * for the task runner.
     * </p>
     * 
     * @return The ID of the task runner. This value should be unique across your AWS account. In the case of AWS Data
     *         Pipeline Task Runner launched on a resource managed by AWS Data Pipeline, the web service provides a
     *         unique identifier when it launches the application. If you have written a custom task runner, you should
     *         assign a unique identifier for the task runner.
     */
    public final String taskrunnerId() {
        return taskrunnerId;
    }

    /**
     * <p>
     * The type of task the task runner is configured to accept and process. The worker group is set as a field on
     * objects in the pipeline when they are created. You can only specify a single value for <code>workerGroup</code>.
     * There are no wildcard values permitted in <code>workerGroup</code>; the string must be an exact, case-sensitive,
     * match.
     * </p>
     * 
     * @return The type of task the task runner is configured to accept and process. The worker group is set as a field
     *         on objects in the pipeline when they are created. You can only specify a single value for
     *         <code>workerGroup</code>. There are no wildcard values permitted in <code>workerGroup</code>; the string
     *         must be an exact, case-sensitive, match.
     */
    public final String workerGroup() {
        return workerGroup;
    }

    /**
     * <p>
     * The public DNS name of the task runner.
     * </p>
     * 
     * @return The public DNS name of the task runner.
     */
    public final String hostname() {
        return hostname;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(taskrunnerId());
        hashCode = 31 * hashCode + Objects.hashCode(workerGroup());
        hashCode = 31 * hashCode + Objects.hashCode(hostname());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReportTaskRunnerHeartbeatRequest)) {
            return false;
        }
        ReportTaskRunnerHeartbeatRequest other = (ReportTaskRunnerHeartbeatRequest) obj;
        return Objects.equals(taskrunnerId(), other.taskrunnerId()) && Objects.equals(workerGroup(), other.workerGroup())
                && Objects.equals(hostname(), other.hostname());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ReportTaskRunnerHeartbeatRequest").add("TaskrunnerId", taskrunnerId())
                .add("WorkerGroup", workerGroup()).add("Hostname", hostname()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "taskrunnerId":
            return Optional.ofNullable(clazz.cast(taskrunnerId()));
        case "workerGroup":
            return Optional.ofNullable(clazz.cast(workerGroup()));
        case "hostname":
            return Optional.ofNullable(clazz.cast(hostname()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ReportTaskRunnerHeartbeatRequest, T> g) {
        return obj -> g.apply((ReportTaskRunnerHeartbeatRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DataPipelineRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, ReportTaskRunnerHeartbeatRequest> {
        /**
         * <p>
         * The ID of the task runner. This value should be unique across your AWS account. In the case of AWS Data
         * Pipeline Task Runner launched on a resource managed by AWS Data Pipeline, the web service provides a unique
         * identifier when it launches the application. If you have written a custom task runner, you should assign a
         * unique identifier for the task runner.
         * </p>
         * 
         * @param taskrunnerId
         *        The ID of the task runner. This value should be unique across your AWS account. In the case of AWS
         *        Data Pipeline Task Runner launched on a resource managed by AWS Data Pipeline, the web service
         *        provides a unique identifier when it launches the application. If you have written a custom task
         *        runner, you should assign a unique identifier for the task runner.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskrunnerId(String taskrunnerId);

        /**
         * <p>
         * The type of task the task runner is configured to accept and process. The worker group is set as a field on
         * objects in the pipeline when they are created. You can only specify a single value for
         * <code>workerGroup</code>. There are no wildcard values permitted in <code>workerGroup</code>; the string must
         * be an exact, case-sensitive, match.
         * </p>
         * 
         * @param workerGroup
         *        The type of task the task runner is configured to accept and process. The worker group is set as a
         *        field on objects in the pipeline when they are created. You can only specify a single value for
         *        <code>workerGroup</code>. There are no wildcard values permitted in <code>workerGroup</code>; the
         *        string must be an exact, case-sensitive, match.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workerGroup(String workerGroup);

        /**
         * <p>
         * The public DNS name of the task runner.
         * </p>
         * 
         * @param hostname
         *        The public DNS name of the task runner.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hostname(String hostname);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DataPipelineRequest.BuilderImpl implements Builder {
        private String taskrunnerId;

        private String workerGroup;

        private String hostname;

        private BuilderImpl() {
        }

        private BuilderImpl(ReportTaskRunnerHeartbeatRequest model) {
            super(model);
            taskrunnerId(model.taskrunnerId);
            workerGroup(model.workerGroup);
            hostname(model.hostname);
        }

        public final String getTaskrunnerId() {
            return taskrunnerId;
        }

        @Override
        public final Builder taskrunnerId(String taskrunnerId) {
            this.taskrunnerId = taskrunnerId;
            return this;
        }

        public final void setTaskrunnerId(String taskrunnerId) {
            this.taskrunnerId = taskrunnerId;
        }

        public final String getWorkerGroup() {
            return workerGroup;
        }

        @Override
        public final Builder workerGroup(String workerGroup) {
            this.workerGroup = workerGroup;
            return this;
        }

        public final void setWorkerGroup(String workerGroup) {
            this.workerGroup = workerGroup;
        }

        public final String getHostname() {
            return hostname;
        }

        @Override
        public final Builder hostname(String hostname) {
            this.hostname = hostname;
            return this;
        }

        public final void setHostname(String hostname) {
            this.hostname = hostname;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ReportTaskRunnerHeartbeatRequest build() {
            return new ReportTaskRunnerHeartbeatRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
