/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datapipeline.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.services.datapipeline.DataPipelineClient;
import software.amazon.awssdk.services.datapipeline.model.DescribeObjectsRequest;
import software.amazon.awssdk.services.datapipeline.model.DescribeObjectsResponse;
import software.amazon.awssdk.services.datapipeline.model.PipelineObject;

public class DescribeObjectsIterable
implements SdkIterable<DescribeObjectsResponse> {
    private final DataPipelineClient client;
    private final DescribeObjectsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeObjectsIterable(DataPipelineClient client, DescribeObjectsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeObjectsResponseFetcher();
    }

    public Iterator<DescribeObjectsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<PipelineObject> pipelineObjects() {
        Function<DescribeObjectsResponse, Iterator> getIterator = response -> {
            if (response != null && response.pipelineObjects() != null) {
                return response.pipelineObjects().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeObjectsResponseFetcher
    implements SyncPageFetcher<DescribeObjectsResponse> {
        private DescribeObjectsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeObjectsResponse previousPage) {
            return previousPage.hasMoreResults();
        }

        public DescribeObjectsResponse nextPage(DescribeObjectsResponse previousPage) {
            if (previousPage == null) {
                return DescribeObjectsIterable.this.client.describeObjects(DescribeObjectsIterable.this.firstRequest);
            }
            return DescribeObjectsIterable.this.client.describeObjects((DescribeObjectsRequest)((Object)DescribeObjectsIterable.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

