/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datapipeline.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the output of EvaluateExpression.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EvaluateExpressionResponse extends DataPipelineResponse implements
        ToCopyableBuilder<EvaluateExpressionResponse.Builder, EvaluateExpressionResponse> {
    private static final SdkField<String> EVALUATED_EXPRESSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(EvaluateExpressionResponse::evaluatedExpression)).setter(setter(Builder::evaluatedExpression))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("evaluatedExpression").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVALUATED_EXPRESSION_FIELD));

    private final String evaluatedExpression;

    private EvaluateExpressionResponse(BuilderImpl builder) {
        super(builder);
        this.evaluatedExpression = builder.evaluatedExpression;
    }

    /**
     * <p>
     * The evaluated expression.
     * </p>
     * 
     * @return The evaluated expression.
     */
    public String evaluatedExpression() {
        return evaluatedExpression;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(evaluatedExpression());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EvaluateExpressionResponse)) {
            return false;
        }
        EvaluateExpressionResponse other = (EvaluateExpressionResponse) obj;
        return Objects.equals(evaluatedExpression(), other.evaluatedExpression());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("EvaluateExpressionResponse").add("EvaluatedExpression", evaluatedExpression()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "evaluatedExpression":
            return Optional.ofNullable(clazz.cast(evaluatedExpression()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EvaluateExpressionResponse, T> g) {
        return obj -> g.apply((EvaluateExpressionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DataPipelineResponse.Builder, SdkPojo, CopyableBuilder<Builder, EvaluateExpressionResponse> {
        /**
         * <p>
         * The evaluated expression.
         * </p>
         * 
         * @param evaluatedExpression
         *        The evaluated expression.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder evaluatedExpression(String evaluatedExpression);
    }

    static final class BuilderImpl extends DataPipelineResponse.BuilderImpl implements Builder {
        private String evaluatedExpression;

        private BuilderImpl() {
        }

        private BuilderImpl(EvaluateExpressionResponse model) {
            super(model);
            evaluatedExpression(model.evaluatedExpression);
        }

        public final String getEvaluatedExpression() {
            return evaluatedExpression;
        }

        @Override
        public final Builder evaluatedExpression(String evaluatedExpression) {
            this.evaluatedExpression = evaluatedExpression;
            return this;
        }

        public final void setEvaluatedExpression(String evaluatedExpression) {
            this.evaluatedExpression = evaluatedExpression;
        }

        @Override
        public EvaluateExpressionResponse build() {
            return new EvaluateExpressionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
