/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datapipeline.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.datapipeline.model.PipelineIdName;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class PipelineIdNameMarshaller {
    private static final MarshallingInfo<String> ID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("id").isBinary(false).build();
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("name").isBinary(false).build();
    private static final PipelineIdNameMarshaller INSTANCE = new PipelineIdNameMarshaller();

    private PipelineIdNameMarshaller() {
    }

    public static PipelineIdNameMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(PipelineIdName pipelineIdName, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)pipelineIdName, (String)"pipelineIdName");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)pipelineIdName.id(), ID_BINDING);
            protocolMarshaller.marshall((Object)pipelineIdName.name(), NAME_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

