/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datapipeline.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.datapipeline.model.DescribePipelinesRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class DescribePipelinesRequestModelMarshaller {
    private static final MarshallingInfo<List> PIPELINEIDS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("pipelineIds").isBinary(false).build();
    private static final DescribePipelinesRequestModelMarshaller INSTANCE = new DescribePipelinesRequestModelMarshaller();

    private DescribePipelinesRequestModelMarshaller() {
    }

    public static DescribePipelinesRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(DescribePipelinesRequest describePipelinesRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)describePipelinesRequest), (String)"describePipelinesRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall(describePipelinesRequest.pipelineIds(), PIPELINEIDS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

