/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datapipeline.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.datapipeline.model.DataPipelineRequest;
import software.amazon.awssdk.services.datapipeline.model._idListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class SetStatusRequest
extends DataPipelineRequest
implements ToCopyableBuilder<Builder, SetStatusRequest> {
    private final String pipelineId;
    private final List<String> objectIds;
    private final String status;

    private SetStatusRequest(BuilderImpl builder) {
        super(builder);
        this.pipelineId = builder.pipelineId;
        this.objectIds = builder.objectIds;
        this.status = builder.status;
    }

    public String pipelineId() {
        return this.pipelineId;
    }

    public List<String> objectIds() {
        return this.objectIds;
    }

    public String status() {
        return this.status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.pipelineId());
        hashCode = 31 * hashCode + Objects.hashCode(this.objectIds());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SetStatusRequest)) {
            return false;
        }
        SetStatusRequest other = (SetStatusRequest)((Object)obj);
        return Objects.equals(this.pipelineId(), other.pipelineId()) && Objects.equals(this.objectIds(), other.objectIds()) && Objects.equals(this.status(), other.status());
    }

    public String toString() {
        return ToString.builder((String)"SetStatusRequest").add("PipelineId", (Object)this.pipelineId()).add("ObjectIds", this.objectIds()).add("Status", (Object)this.status()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "pipelineId": {
                return Optional.of(clazz.cast(this.pipelineId()));
            }
            case "objectIds": {
                return Optional.of(clazz.cast(this.objectIds()));
            }
            case "status": {
                return Optional.of(clazz.cast(this.status()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends DataPipelineRequest.BuilderImpl
    implements Builder {
        private String pipelineId;
        private List<String> objectIds;
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(SetStatusRequest model) {
            this.pipelineId(model.pipelineId);
            this.objectIds(model.objectIds);
            this.status(model.status);
        }

        public final String getPipelineId() {
            return this.pipelineId;
        }

        @Override
        public final Builder pipelineId(String pipelineId) {
            this.pipelineId = pipelineId;
            return this;
        }

        public final void setPipelineId(String pipelineId) {
            this.pipelineId = pipelineId;
        }

        public final Collection<String> getObjectIds() {
            return this.objectIds;
        }

        @Override
        public final Builder objectIds(Collection<String> objectIds) {
            this.objectIds = _idListCopier.copy(objectIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder objectIds(String ... objectIds) {
            this.objectIds(Arrays.asList(objectIds));
            return this;
        }

        public final void setObjectIds(Collection<String> objectIds) {
            this.objectIds = _idListCopier.copy(objectIds);
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public SetStatusRequest build() {
            return new SetStatusRequest(this);
        }
    }

    public static interface Builder
    extends DataPipelineRequest.Builder,
    CopyableBuilder<Builder, SetStatusRequest> {
        public Builder pipelineId(String var1);

        public Builder objectIds(Collection<String> var1);

        public Builder objectIds(String ... var1);

        public Builder status(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

