/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datapipeline.paginators;

import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.datapipeline.DataPipelineClient;
import software.amazon.awssdk.services.datapipeline.model.ListPipelinesRequest;
import software.amazon.awssdk.services.datapipeline.model.ListPipelinesResponse;
import software.amazon.awssdk.services.datapipeline.model.PipelineIdName;

public final class ListPipelinesPaginator
implements SdkIterable<ListPipelinesResponse> {
    private final DataPipelineClient client;
    private final ListPipelinesRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public ListPipelinesPaginator(DataPipelineClient client, ListPipelinesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListPipelinesResponseFetcher();
    }

    public Iterator<ListPipelinesResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public SdkIterable<PipelineIdName> pipelineIdList() {
        Function<ListPipelinesResponse, Iterator> getIterator = response -> response != null ? response.pipelineIdList().iterator() : null;
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    private class ListPipelinesResponseFetcher
    implements NextPageFetcher<ListPipelinesResponse> {
        private ListPipelinesResponseFetcher() {
        }

        public boolean hasNextPage(ListPipelinesResponse previousPage) {
            return previousPage.hasMoreResults();
        }

        public ListPipelinesResponse nextPage(ListPipelinesResponse previousPage) {
            if (previousPage == null) {
                return ListPipelinesPaginator.this.client.listPipelines(ListPipelinesPaginator.this.firstRequest);
            }
            return ListPipelinesPaginator.this.client.listPipelines((ListPipelinesRequest)((Object)ListPipelinesPaginator.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

