/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datapipeline.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.ListUnmarshaller;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.datapipeline.model.Operator;

public class OperatorUnmarshaller
implements Unmarshaller<Operator, JsonUnmarshallerContext> {
    private static final OperatorUnmarshaller INSTANCE = new OperatorUnmarshaller();

    public Operator unmarshall(JsonUnmarshallerContext context) throws Exception {
        Operator.Builder operatorBuilder = Operator.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("type", targetDepth)) {
                    context.nextToken();
                    operatorBuilder.type((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("values", targetDepth)) {
                    context.nextToken();
                    operatorBuilder.values(new ListUnmarshaller(context.getUnmarshaller(String.class)).unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (Operator)operatorBuilder.build();
    }

    public static OperatorUnmarshaller getInstance() {
        return INSTANCE;
    }
}

