/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datapipeline.paginators;

import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.datapipeline.DataPipelineClient;
import software.amazon.awssdk.services.datapipeline.model.QueryObjectsRequest;
import software.amazon.awssdk.services.datapipeline.model.QueryObjectsResponse;

public final class QueryObjectsPaginator
implements SdkIterable<QueryObjectsResponse> {
    private final DataPipelineClient client;
    private final QueryObjectsRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public QueryObjectsPaginator(DataPipelineClient client, QueryObjectsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new QueryObjectsResponseFetcher();
    }

    public Iterator<QueryObjectsResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public SdkIterable<String> ids() {
        Function<QueryObjectsResponse, Iterator> getIterator = response -> response != null ? response.ids().iterator() : null;
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    private class QueryObjectsResponseFetcher
    implements NextPageFetcher<QueryObjectsResponse> {
        private QueryObjectsResponseFetcher() {
        }

        public boolean hasNextPage(QueryObjectsResponse previousPage) {
            return previousPage.hasMoreResults();
        }

        public QueryObjectsResponse nextPage(QueryObjectsResponse previousPage) {
            if (previousPage == null) {
                return QueryObjectsPaginator.this.client.queryObjects(QueryObjectsPaginator.this.firstRequest);
            }
            return QueryObjectsPaginator.this.client.queryObjects((QueryObjectsRequest)((Object)QueryObjectsPaginator.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

