/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datapipeline.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.datapipeline.model.DataPipelineRequest;
import software.amazon.awssdk.services.datapipeline.model.ParameterValue;
import software.amazon.awssdk.services.datapipeline.model.ParameterValueListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ActivatePipelineRequest
extends DataPipelineRequest
implements ToCopyableBuilder<Builder, ActivatePipelineRequest> {
    private final String pipelineId;
    private final List<ParameterValue> parameterValues;
    private final Instant startTimestamp;

    private ActivatePipelineRequest(BuilderImpl builder) {
        super(builder);
        this.pipelineId = builder.pipelineId;
        this.parameterValues = builder.parameterValues;
        this.startTimestamp = builder.startTimestamp;
    }

    public String pipelineId() {
        return this.pipelineId;
    }

    public List<ParameterValue> parameterValues() {
        return this.parameterValues;
    }

    public Instant startTimestamp() {
        return this.startTimestamp;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.pipelineId());
        hashCode = 31 * hashCode + Objects.hashCode(this.parameterValues());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTimestamp());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ActivatePipelineRequest)) {
            return false;
        }
        ActivatePipelineRequest other = (ActivatePipelineRequest)((Object)obj);
        return Objects.equals(this.pipelineId(), other.pipelineId()) && Objects.equals(this.parameterValues(), other.parameterValues()) && Objects.equals(this.startTimestamp(), other.startTimestamp());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.pipelineId() != null) {
            sb.append("PipelineId: ").append(this.pipelineId()).append(",");
        }
        if (this.parameterValues() != null) {
            sb.append("ParameterValues: ").append(this.parameterValues()).append(",");
        }
        if (this.startTimestamp() != null) {
            sb.append("StartTimestamp: ").append(this.startTimestamp()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "pipelineId": {
                return Optional.of(clazz.cast(this.pipelineId()));
            }
            case "parameterValues": {
                return Optional.of(clazz.cast(this.parameterValues()));
            }
            case "startTimestamp": {
                return Optional.of(clazz.cast(this.startTimestamp()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends DataPipelineRequest.BuilderImpl
    implements Builder {
        private String pipelineId;
        private List<ParameterValue> parameterValues;
        private Instant startTimestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(ActivatePipelineRequest model) {
            this.pipelineId(model.pipelineId);
            this.parameterValues(model.parameterValues);
            this.startTimestamp(model.startTimestamp);
        }

        public final String getPipelineId() {
            return this.pipelineId;
        }

        @Override
        public final Builder pipelineId(String pipelineId) {
            this.pipelineId = pipelineId;
            return this;
        }

        public final void setPipelineId(String pipelineId) {
            this.pipelineId = pipelineId;
        }

        public final Collection<ParameterValue.Builder> getParameterValues() {
            return this.parameterValues != null ? (Collection)this.parameterValues.stream().map(ParameterValue::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder parameterValues(Collection<ParameterValue> parameterValues) {
            this.parameterValues = ParameterValueListCopier.copy(parameterValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameterValues(ParameterValue ... parameterValues) {
            this.parameterValues(Arrays.asList(parameterValues));
            return this;
        }

        public final void setParameterValues(Collection<ParameterValue.BuilderImpl> parameterValues) {
            this.parameterValues = ParameterValueListCopier.copyFromBuilder(parameterValues);
        }

        public final Instant getStartTimestamp() {
            return this.startTimestamp;
        }

        @Override
        public final Builder startTimestamp(Instant startTimestamp) {
            this.startTimestamp = startTimestamp;
            return this;
        }

        public final void setStartTimestamp(Instant startTimestamp) {
            this.startTimestamp = startTimestamp;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public ActivatePipelineRequest build() {
            return new ActivatePipelineRequest(this);
        }
    }

    public static interface Builder
    extends DataPipelineRequest.Builder,
    CopyableBuilder<Builder, ActivatePipelineRequest> {
        public Builder pipelineId(String var1);

        public Builder parameterValues(Collection<ParameterValue> var1);

        public Builder parameterValues(ParameterValue ... var1);

        public Builder startTimestamp(Instant var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

