/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datapipeline.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.datapipeline.model.InstanceIdentity;

public class InstanceIdentityUnmarshaller
implements Unmarshaller<InstanceIdentity, JsonUnmarshallerContext> {
    private static final InstanceIdentityUnmarshaller INSTANCE = new InstanceIdentityUnmarshaller();

    public InstanceIdentity unmarshall(JsonUnmarshallerContext context) throws Exception {
        InstanceIdentity.Builder instanceIdentityBuilder = InstanceIdentity.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("document", targetDepth)) {
                    context.nextToken();
                    instanceIdentityBuilder.document((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("signature", targetDepth)) {
                    context.nextToken();
                    instanceIdentityBuilder.signature((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (InstanceIdentity)instanceIdentityBuilder.build();
    }

    public static InstanceIdentityUnmarshaller getInstance() {
        return INSTANCE;
    }
}

