/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datapipeline.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.datapipeline.model._idListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribePipelinesRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, DescribePipelinesRequest> {
    private final List<String> pipelineIds;

    private DescribePipelinesRequest(BuilderImpl builder) {
        this.pipelineIds = builder.pipelineIds;
    }

    public List<String> pipelineIds() {
        return this.pipelineIds;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.pipelineIds());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribePipelinesRequest)) {
            return false;
        }
        DescribePipelinesRequest other = (DescribePipelinesRequest)((Object)obj);
        return Objects.equals(this.pipelineIds(), other.pipelineIds());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.pipelineIds() != null) {
            sb.append("PipelineIds: ").append(this.pipelineIds()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "pipelineIds": {
                return Optional.of(clazz.cast(this.pipelineIds()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> pipelineIds;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribePipelinesRequest model) {
            this.pipelineIds(model.pipelineIds);
        }

        public final Collection<String> getPipelineIds() {
            return this.pipelineIds;
        }

        @Override
        public final Builder pipelineIds(Collection<String> pipelineIds) {
            this.pipelineIds = _idListCopier.copy(pipelineIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pipelineIds(String ... pipelineIds) {
            this.pipelineIds(Arrays.asList(pipelineIds));
            return this;
        }

        public final void setPipelineIds(Collection<String> pipelineIds) {
            this.pipelineIds = _idListCopier.copy(pipelineIds);
        }

        public DescribePipelinesRequest build() {
            return new DescribePipelinesRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribePipelinesRequest> {
        public Builder pipelineIds(Collection<String> var1);

        public Builder pipelineIds(String ... var1);
    }
}

