/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datapipeline.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.datapipeline.model.ValidationError;
import software.amazon.awssdk.services.datapipeline.model.ValidationErrorsCopier;
import software.amazon.awssdk.services.datapipeline.model.ValidationWarning;
import software.amazon.awssdk.services.datapipeline.model.ValidationWarningsCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class PutPipelineDefinitionResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, PutPipelineDefinitionResponse> {
    private final List<ValidationError> validationErrors;
    private final List<ValidationWarning> validationWarnings;
    private final Boolean errored;

    private PutPipelineDefinitionResponse(BuilderImpl builder) {
        this.validationErrors = builder.validationErrors;
        this.validationWarnings = builder.validationWarnings;
        this.errored = builder.errored;
    }

    public List<ValidationError> validationErrors() {
        return this.validationErrors;
    }

    public List<ValidationWarning> validationWarnings() {
        return this.validationWarnings;
    }

    public Boolean errored() {
        return this.errored;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.validationErrors() == null ? 0 : this.validationErrors().hashCode());
        hashCode = 31 * hashCode + (this.validationWarnings() == null ? 0 : this.validationWarnings().hashCode());
        hashCode = 31 * hashCode + (this.errored() == null ? 0 : this.errored().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutPipelineDefinitionResponse)) {
            return false;
        }
        PutPipelineDefinitionResponse other = (PutPipelineDefinitionResponse)((Object)obj);
        if (other.validationErrors() == null ^ this.validationErrors() == null) {
            return false;
        }
        if (other.validationErrors() != null && !other.validationErrors().equals(this.validationErrors())) {
            return false;
        }
        if (other.validationWarnings() == null ^ this.validationWarnings() == null) {
            return false;
        }
        if (other.validationWarnings() != null && !other.validationWarnings().equals(this.validationWarnings())) {
            return false;
        }
        if (other.errored() == null ^ this.errored() == null) {
            return false;
        }
        return other.errored() == null || other.errored().equals(this.errored());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.validationErrors() != null) {
            sb.append("ValidationErrors: ").append(this.validationErrors()).append(",");
        }
        if (this.validationWarnings() != null) {
            sb.append("ValidationWarnings: ").append(this.validationWarnings()).append(",");
        }
        if (this.errored() != null) {
            sb.append("Errored: ").append(this.errored()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "validationErrors": {
                return Optional.of(clazz.cast(this.validationErrors()));
            }
            case "validationWarnings": {
                return Optional.of(clazz.cast(this.validationWarnings()));
            }
            case "errored": {
                return Optional.of(clazz.cast(this.errored()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<ValidationError> validationErrors;
        private List<ValidationWarning> validationWarnings;
        private Boolean errored;

        private BuilderImpl() {
        }

        private BuilderImpl(PutPipelineDefinitionResponse model) {
            this.validationErrors(model.validationErrors);
            this.validationWarnings(model.validationWarnings);
            this.errored(model.errored);
        }

        public final Collection<ValidationError.Builder> getValidationErrors() {
            return this.validationErrors != null ? (Collection)this.validationErrors.stream().map(ValidationError::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder validationErrors(Collection<ValidationError> validationErrors) {
            this.validationErrors = ValidationErrorsCopier.copy(validationErrors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder validationErrors(ValidationError ... validationErrors) {
            this.validationErrors(Arrays.asList(validationErrors));
            return this;
        }

        public final void setValidationErrors(Collection<ValidationError.BuilderImpl> validationErrors) {
            this.validationErrors = ValidationErrorsCopier.copyFromBuilder(validationErrors);
        }

        public final Collection<ValidationWarning.Builder> getValidationWarnings() {
            return this.validationWarnings != null ? (Collection)this.validationWarnings.stream().map(ValidationWarning::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder validationWarnings(Collection<ValidationWarning> validationWarnings) {
            this.validationWarnings = ValidationWarningsCopier.copy(validationWarnings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder validationWarnings(ValidationWarning ... validationWarnings) {
            this.validationWarnings(Arrays.asList(validationWarnings));
            return this;
        }

        public final void setValidationWarnings(Collection<ValidationWarning.BuilderImpl> validationWarnings) {
            this.validationWarnings = ValidationWarningsCopier.copyFromBuilder(validationWarnings);
        }

        public final Boolean getErrored() {
            return this.errored;
        }

        @Override
        public final Builder errored(Boolean errored) {
            this.errored = errored;
            return this;
        }

        public final void setErrored(Boolean errored) {
            this.errored = errored;
        }

        public PutPipelineDefinitionResponse build() {
            return new PutPipelineDefinitionResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, PutPipelineDefinitionResponse> {
        public Builder validationErrors(Collection<ValidationError> var1);

        public Builder validationErrors(ValidationError ... var1);

        public Builder validationWarnings(Collection<ValidationWarning> var1);

        public Builder validationWarnings(ValidationWarning ... var1);

        public Builder errored(Boolean var1);
    }
}

