/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datapipeline.model;

import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class EvaluateExpressionRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, EvaluateExpressionRequest> {
    private final String pipelineId;
    private final String objectId;
    private final String expression;

    private EvaluateExpressionRequest(BuilderImpl builder) {
        this.pipelineId = builder.pipelineId;
        this.objectId = builder.objectId;
        this.expression = builder.expression;
    }

    public String pipelineId() {
        return this.pipelineId;
    }

    public String objectId() {
        return this.objectId;
    }

    public String expression() {
        return this.expression;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.pipelineId() == null ? 0 : this.pipelineId().hashCode());
        hashCode = 31 * hashCode + (this.objectId() == null ? 0 : this.objectId().hashCode());
        hashCode = 31 * hashCode + (this.expression() == null ? 0 : this.expression().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EvaluateExpressionRequest)) {
            return false;
        }
        EvaluateExpressionRequest other = (EvaluateExpressionRequest)((Object)obj);
        if (other.pipelineId() == null ^ this.pipelineId() == null) {
            return false;
        }
        if (other.pipelineId() != null && !other.pipelineId().equals(this.pipelineId())) {
            return false;
        }
        if (other.objectId() == null ^ this.objectId() == null) {
            return false;
        }
        if (other.objectId() != null && !other.objectId().equals(this.objectId())) {
            return false;
        }
        if (other.expression() == null ^ this.expression() == null) {
            return false;
        }
        return other.expression() == null || other.expression().equals(this.expression());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.pipelineId() != null) {
            sb.append("PipelineId: ").append(this.pipelineId()).append(",");
        }
        if (this.objectId() != null) {
            sb.append("ObjectId: ").append(this.objectId()).append(",");
        }
        if (this.expression() != null) {
            sb.append("Expression: ").append(this.expression()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "pipelineId": {
                return Optional.of(clazz.cast(this.pipelineId()));
            }
            case "objectId": {
                return Optional.of(clazz.cast(this.objectId()));
            }
            case "expression": {
                return Optional.of(clazz.cast(this.expression()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String pipelineId;
        private String objectId;
        private String expression;

        private BuilderImpl() {
        }

        private BuilderImpl(EvaluateExpressionRequest model) {
            this.pipelineId(model.pipelineId);
            this.objectId(model.objectId);
            this.expression(model.expression);
        }

        public final String getPipelineId() {
            return this.pipelineId;
        }

        @Override
        public final Builder pipelineId(String pipelineId) {
            this.pipelineId = pipelineId;
            return this;
        }

        public final void setPipelineId(String pipelineId) {
            this.pipelineId = pipelineId;
        }

        public final String getObjectId() {
            return this.objectId;
        }

        @Override
        public final Builder objectId(String objectId) {
            this.objectId = objectId;
            return this;
        }

        public final void setObjectId(String objectId) {
            this.objectId = objectId;
        }

        public final String getExpression() {
            return this.expression;
        }

        @Override
        public final Builder expression(String expression) {
            this.expression = expression;
            return this;
        }

        public final void setExpression(String expression) {
            this.expression = expression;
        }

        public EvaluateExpressionRequest build() {
            return new EvaluateExpressionRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, EvaluateExpressionRequest> {
        public Builder pipelineId(String var1);

        public Builder objectId(String var1);

        public Builder expression(String var1);
    }
}

