/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datapipeline.model;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.datapipeline.model.Query;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class QueryObjectsRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, QueryObjectsRequest> {
    private final String pipelineId;
    private final Query query;
    private final String sphere;
    private final String marker;
    private final Integer limit;

    private QueryObjectsRequest(BuilderImpl builder) {
        this.pipelineId = builder.pipelineId;
        this.query = builder.query;
        this.sphere = builder.sphere;
        this.marker = builder.marker;
        this.limit = builder.limit;
    }

    public String pipelineId() {
        return this.pipelineId;
    }

    public Query query() {
        return this.query;
    }

    public String sphere() {
        return this.sphere;
    }

    public String marker() {
        return this.marker;
    }

    public Integer limit() {
        return this.limit;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.pipelineId() == null ? 0 : this.pipelineId().hashCode());
        hashCode = 31 * hashCode + (this.query() == null ? 0 : this.query().hashCode());
        hashCode = 31 * hashCode + (this.sphere() == null ? 0 : this.sphere().hashCode());
        hashCode = 31 * hashCode + (this.marker() == null ? 0 : this.marker().hashCode());
        hashCode = 31 * hashCode + (this.limit() == null ? 0 : this.limit().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof QueryObjectsRequest)) {
            return false;
        }
        QueryObjectsRequest other = (QueryObjectsRequest)((Object)obj);
        if (other.pipelineId() == null ^ this.pipelineId() == null) {
            return false;
        }
        if (other.pipelineId() != null && !other.pipelineId().equals(this.pipelineId())) {
            return false;
        }
        if (other.query() == null ^ this.query() == null) {
            return false;
        }
        if (other.query() != null && !other.query().equals(this.query())) {
            return false;
        }
        if (other.sphere() == null ^ this.sphere() == null) {
            return false;
        }
        if (other.sphere() != null && !other.sphere().equals(this.sphere())) {
            return false;
        }
        if (other.marker() == null ^ this.marker() == null) {
            return false;
        }
        if (other.marker() != null && !other.marker().equals(this.marker())) {
            return false;
        }
        if (other.limit() == null ^ this.limit() == null) {
            return false;
        }
        return other.limit() == null || other.limit().equals(this.limit());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.pipelineId() != null) {
            sb.append("PipelineId: ").append(this.pipelineId()).append(",");
        }
        if (this.query() != null) {
            sb.append("Query: ").append(this.query()).append(",");
        }
        if (this.sphere() != null) {
            sb.append("Sphere: ").append(this.sphere()).append(",");
        }
        if (this.marker() != null) {
            sb.append("Marker: ").append(this.marker()).append(",");
        }
        if (this.limit() != null) {
            sb.append("Limit: ").append(this.limit()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String pipelineId;
        private Query query;
        private String sphere;
        private String marker;
        private Integer limit;

        private BuilderImpl() {
        }

        private BuilderImpl(QueryObjectsRequest model) {
            this.setPipelineId(model.pipelineId);
            this.setQuery(model.query);
            this.setSphere(model.sphere);
            this.setMarker(model.marker);
            this.setLimit(model.limit);
        }

        public final String getPipelineId() {
            return this.pipelineId;
        }

        @Override
        public final Builder pipelineId(String pipelineId) {
            this.pipelineId = pipelineId;
            return this;
        }

        public final void setPipelineId(String pipelineId) {
            this.pipelineId = pipelineId;
        }

        public final Query getQuery() {
            return this.query;
        }

        @Override
        public final Builder query(Query query) {
            this.query = query;
            return this;
        }

        public final void setQuery(Query query) {
            this.query = query;
        }

        public final String getSphere() {
            return this.sphere;
        }

        @Override
        public final Builder sphere(String sphere) {
            this.sphere = sphere;
            return this;
        }

        public final void setSphere(String sphere) {
            this.sphere = sphere;
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final Integer getLimit() {
            return this.limit;
        }

        @Override
        public final Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public final void setLimit(Integer limit) {
            this.limit = limit;
        }

        public QueryObjectsRequest build() {
            return new QueryObjectsRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, QueryObjectsRequest> {
        public Builder pipelineId(String var1);

        public Builder query(Query var1);

        public Builder sphere(String var1);

        public Builder marker(String var1);

        public Builder limit(Integer var1);
    }
}

