/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datapipeline.transform;

import java.util.Map;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.datapipeline.model.TaskObject;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class TaskObjectMarshaller {
    private static final MarshallingInfo<String> TASKID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("taskId").isBinary(false).build();
    private static final MarshallingInfo<String> PIPELINEID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("pipelineId").isBinary(false).build();
    private static final MarshallingInfo<String> ATTEMPTID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("attemptId").isBinary(false).build();
    private static final MarshallingInfo<Map> OBJECTS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("objects").isBinary(false).build();
    private static final TaskObjectMarshaller INSTANCE = new TaskObjectMarshaller();

    private TaskObjectMarshaller() {
    }

    public static TaskObjectMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(TaskObject taskObject, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)taskObject, (String)"taskObject");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)taskObject.taskId(), TASKID_BINDING);
            protocolMarshaller.marshall((Object)taskObject.pipelineId(), PIPELINEID_BINDING);
            protocolMarshaller.marshall((Object)taskObject.attemptId(), ATTEMPTID_BINDING);
            protocolMarshaller.marshall(taskObject.objects(), OBJECTS_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

