/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datapipeline.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.services.datapipeline.model.DataPipelineRequest;
import software.amazon.awssdk.services.datapipeline.model.TaskStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SetTaskStatusRequest
extends DataPipelineRequest
implements ToCopyableBuilder<Builder, SetTaskStatusRequest> {
    private final String taskId;
    private final String taskStatus;
    private final String errorId;
    private final String errorMessage;
    private final String errorStackTrace;

    private SetTaskStatusRequest(BuilderImpl builder) {
        super(builder);
        this.taskId = builder.taskId;
        this.taskStatus = builder.taskStatus;
        this.errorId = builder.errorId;
        this.errorMessage = builder.errorMessage;
        this.errorStackTrace = builder.errorStackTrace;
    }

    public String taskId() {
        return this.taskId;
    }

    public TaskStatus taskStatus() {
        return TaskStatus.fromValue(this.taskStatus);
    }

    public String taskStatusAsString() {
        return this.taskStatus;
    }

    public String errorId() {
        return this.errorId;
    }

    public String errorMessage() {
        return this.errorMessage;
    }

    public String errorStackTrace() {
        return this.errorStackTrace;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.taskId());
        hashCode = 31 * hashCode + Objects.hashCode(this.taskStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.errorId());
        hashCode = 31 * hashCode + Objects.hashCode(this.errorMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.errorStackTrace());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SetTaskStatusRequest)) {
            return false;
        }
        SetTaskStatusRequest other = (SetTaskStatusRequest)((Object)obj);
        return Objects.equals(this.taskId(), other.taskId()) && Objects.equals(this.taskStatusAsString(), other.taskStatusAsString()) && Objects.equals(this.errorId(), other.errorId()) && Objects.equals(this.errorMessage(), other.errorMessage()) && Objects.equals(this.errorStackTrace(), other.errorStackTrace());
    }

    public String toString() {
        return ToString.builder((String)"SetTaskStatusRequest").add("TaskId", (Object)this.taskId()).add("TaskStatus", (Object)this.taskStatusAsString()).add("ErrorId", (Object)this.errorId()).add("ErrorMessage", (Object)this.errorMessage()).add("ErrorStackTrace", (Object)this.errorStackTrace()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "taskId": {
                return Optional.ofNullable(clazz.cast(this.taskId()));
            }
            case "taskStatus": {
                return Optional.ofNullable(clazz.cast(this.taskStatusAsString()));
            }
            case "errorId": {
                return Optional.ofNullable(clazz.cast(this.errorId()));
            }
            case "errorMessage": {
                return Optional.ofNullable(clazz.cast(this.errorMessage()));
            }
            case "errorStackTrace": {
                return Optional.ofNullable(clazz.cast(this.errorStackTrace()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends DataPipelineRequest.BuilderImpl
    implements Builder {
        private String taskId;
        private String taskStatus;
        private String errorId;
        private String errorMessage;
        private String errorStackTrace;

        private BuilderImpl() {
        }

        private BuilderImpl(SetTaskStatusRequest model) {
            super(model);
            this.taskId(model.taskId);
            this.taskStatus(model.taskStatus);
            this.errorId(model.errorId);
            this.errorMessage(model.errorMessage);
            this.errorStackTrace(model.errorStackTrace);
        }

        public final String getTaskId() {
            return this.taskId;
        }

        @Override
        public final Builder taskId(String taskId) {
            this.taskId = taskId;
            return this;
        }

        public final void setTaskId(String taskId) {
            this.taskId = taskId;
        }

        public final String getTaskStatus() {
            return this.taskStatus;
        }

        @Override
        public final Builder taskStatus(String taskStatus) {
            this.taskStatus = taskStatus;
            return this;
        }

        @Override
        public final Builder taskStatus(TaskStatus taskStatus) {
            this.taskStatus(taskStatus.toString());
            return this;
        }

        public final void setTaskStatus(String taskStatus) {
            this.taskStatus = taskStatus;
        }

        public final String getErrorId() {
            return this.errorId;
        }

        @Override
        public final Builder errorId(String errorId) {
            this.errorId = errorId;
            return this;
        }

        public final void setErrorId(String errorId) {
            this.errorId = errorId;
        }

        public final String getErrorMessage() {
            return this.errorMessage;
        }

        @Override
        public final Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public final void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        public final String getErrorStackTrace() {
            return this.errorStackTrace;
        }

        @Override
        public final Builder errorStackTrace(String errorStackTrace) {
            this.errorStackTrace = errorStackTrace;
            return this;
        }

        public final void setErrorStackTrace(String errorStackTrace) {
            this.errorStackTrace = errorStackTrace;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SetTaskStatusRequest build() {
            return new SetTaskStatusRequest(this);
        }
    }

    public static interface Builder
    extends DataPipelineRequest.Builder,
    CopyableBuilder<Builder, SetTaskStatusRequest> {
        public Builder taskId(String var1);

        public Builder taskStatus(String var1);

        public Builder taskStatus(TaskStatus var1);

        public Builder errorId(String var1);

        public Builder errorMessage(String var1);

        public Builder errorStackTrace(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

