/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datapipeline.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.datapipeline.model.DataPipelineResponse;
import software.amazon.awssdk.services.datapipeline.model._idListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class QueryObjectsResponse
extends DataPipelineResponse
implements ToCopyableBuilder<Builder, QueryObjectsResponse> {
    private final List<String> ids;
    private final String marker;
    private final Boolean hasMoreResults;

    private QueryObjectsResponse(BuilderImpl builder) {
        super(builder);
        this.ids = builder.ids;
        this.marker = builder.marker;
        this.hasMoreResults = builder.hasMoreResults;
    }

    public List<String> ids() {
        return this.ids;
    }

    public String marker() {
        return this.marker;
    }

    public Boolean hasMoreResults() {
        return this.hasMoreResults;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.ids());
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMoreResults());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof QueryObjectsResponse)) {
            return false;
        }
        QueryObjectsResponse other = (QueryObjectsResponse)((Object)obj);
        return Objects.equals(this.ids(), other.ids()) && Objects.equals(this.marker(), other.marker()) && Objects.equals(this.hasMoreResults(), other.hasMoreResults());
    }

    public String toString() {
        return ToString.builder((String)"QueryObjectsResponse").add("Ids", this.ids()).add("Marker", (Object)this.marker()).add("HasMoreResults", (Object)this.hasMoreResults()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ids": {
                return Optional.ofNullable(clazz.cast(this.ids()));
            }
            case "marker": {
                return Optional.ofNullable(clazz.cast(this.marker()));
            }
            case "hasMoreResults": {
                return Optional.ofNullable(clazz.cast(this.hasMoreResults()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends DataPipelineResponse.BuilderImpl
    implements Builder {
        private List<String> ids = DefaultSdkAutoConstructList.getInstance();
        private String marker;
        private Boolean hasMoreResults;

        private BuilderImpl() {
        }

        private BuilderImpl(QueryObjectsResponse model) {
            super(model);
            this.ids(model.ids);
            this.marker(model.marker);
            this.hasMoreResults(model.hasMoreResults);
        }

        public final Collection<String> getIds() {
            return this.ids;
        }

        @Override
        public final Builder ids(Collection<String> ids) {
            this.ids = _idListCopier.copy(ids);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ids(String ... ids) {
            this.ids(Arrays.asList(ids));
            return this;
        }

        public final void setIds(Collection<String> ids) {
            this.ids = _idListCopier.copy(ids);
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final Boolean getHasMoreResults() {
            return this.hasMoreResults;
        }

        @Override
        public final Builder hasMoreResults(Boolean hasMoreResults) {
            this.hasMoreResults = hasMoreResults;
            return this;
        }

        public final void setHasMoreResults(Boolean hasMoreResults) {
            this.hasMoreResults = hasMoreResults;
        }

        @Override
        public QueryObjectsResponse build() {
            return new QueryObjectsResponse(this);
        }
    }

    public static interface Builder
    extends DataPipelineResponse.Builder,
    CopyableBuilder<Builder, QueryObjectsResponse> {
        public Builder ids(Collection<String> var1);

        public Builder ids(String ... var1);

        public Builder marker(String var1);

        public Builder hasMoreResults(Boolean var1);
    }
}

