/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datapipeline.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.datapipeline.model.ParameterValue;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ParameterValueMarshaller {
    private static final MarshallingInfo<String> ID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("id").isBinary(false).build();
    private static final MarshallingInfo<String> STRINGVALUE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("stringValue").isBinary(false).build();
    private static final ParameterValueMarshaller INSTANCE = new ParameterValueMarshaller();

    private ParameterValueMarshaller() {
    }

    public static ParameterValueMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ParameterValue parameterValue, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)parameterValue, (String)"parameterValue");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)parameterValue.id(), ID_BINDING);
            protocolMarshaller.marshall((Object)parameterValue.stringValue(), STRINGVALUE_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

