/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datapipeline.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.datapipeline.model.ParameterObject;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ParameterObjectMarshaller {
    private static final MarshallingInfo<String> ID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("id").isBinary(false).build();
    private static final MarshallingInfo<List> ATTRIBUTES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("attributes").isBinary(false).build();
    private static final ParameterObjectMarshaller INSTANCE = new ParameterObjectMarshaller();

    private ParameterObjectMarshaller() {
    }

    public static ParameterObjectMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ParameterObject parameterObject, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)parameterObject, (String)"parameterObject");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)parameterObject.id(), ID_BINDING);
            protocolMarshaller.marshall(parameterObject.attributes(), ATTRIBUTES_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

