/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datapipeline.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.services.datapipeline.model.DataPipelineRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EvaluateExpressionRequest
extends DataPipelineRequest
implements ToCopyableBuilder<Builder, EvaluateExpressionRequest> {
    private final String pipelineId;
    private final String objectId;
    private final String expression;

    private EvaluateExpressionRequest(BuilderImpl builder) {
        super(builder);
        this.pipelineId = builder.pipelineId;
        this.objectId = builder.objectId;
        this.expression = builder.expression;
    }

    public String pipelineId() {
        return this.pipelineId;
    }

    public String objectId() {
        return this.objectId;
    }

    public String expression() {
        return this.expression;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.pipelineId());
        hashCode = 31 * hashCode + Objects.hashCode(this.objectId());
        hashCode = 31 * hashCode + Objects.hashCode(this.expression());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EvaluateExpressionRequest)) {
            return false;
        }
        EvaluateExpressionRequest other = (EvaluateExpressionRequest)((Object)obj);
        return Objects.equals(this.pipelineId(), other.pipelineId()) && Objects.equals(this.objectId(), other.objectId()) && Objects.equals(this.expression(), other.expression());
    }

    public String toString() {
        return ToString.builder((String)"EvaluateExpressionRequest").add("PipelineId", (Object)this.pipelineId()).add("ObjectId", (Object)this.objectId()).add("Expression", (Object)this.expression()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "pipelineId": {
                return Optional.ofNullable(clazz.cast(this.pipelineId()));
            }
            case "objectId": {
                return Optional.ofNullable(clazz.cast(this.objectId()));
            }
            case "expression": {
                return Optional.ofNullable(clazz.cast(this.expression()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends DataPipelineRequest.BuilderImpl
    implements Builder {
        private String pipelineId;
        private String objectId;
        private String expression;

        private BuilderImpl() {
        }

        private BuilderImpl(EvaluateExpressionRequest model) {
            super(model);
            this.pipelineId(model.pipelineId);
            this.objectId(model.objectId);
            this.expression(model.expression);
        }

        public final String getPipelineId() {
            return this.pipelineId;
        }

        @Override
        public final Builder pipelineId(String pipelineId) {
            this.pipelineId = pipelineId;
            return this;
        }

        public final void setPipelineId(String pipelineId) {
            this.pipelineId = pipelineId;
        }

        public final String getObjectId() {
            return this.objectId;
        }

        @Override
        public final Builder objectId(String objectId) {
            this.objectId = objectId;
            return this;
        }

        public final void setObjectId(String objectId) {
            this.objectId = objectId;
        }

        public final String getExpression() {
            return this.expression;
        }

        @Override
        public final Builder expression(String expression) {
            this.expression = expression;
            return this;
        }

        public final void setExpression(String expression) {
            this.expression = expression;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public EvaluateExpressionRequest build() {
            return new EvaluateExpressionRequest(this);
        }
    }

    public static interface Builder
    extends DataPipelineRequest.Builder,
    CopyableBuilder<Builder, EvaluateExpressionRequest> {
        public Builder pipelineId(String var1);

        public Builder objectId(String var1);

        public Builder expression(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

