/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datapipeline.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.datapipeline.model.Selector;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class SelectorMarshaller {
    private static final MarshallingInfo<String> FIELDNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("fieldName").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> OPERATOR_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("operator").isBinary(false).build();
    private static final SelectorMarshaller INSTANCE = new SelectorMarshaller();

    private SelectorMarshaller() {
    }

    public static SelectorMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(Selector selector, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)selector, (String)"selector");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)selector.fieldName(), FIELDNAME_BINDING);
            protocolMarshaller.marshall((Object)selector.operator(), OPERATOR_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

