/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datapipeline.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.protocol.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.protocol.OperationInfo;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.ProtocolRequestMarshaller;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.services.datapipeline.model.ReportTaskProgressRequest;
import software.amazon.awssdk.services.datapipeline.transform.ReportTaskProgressRequestModelMarshaller;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ReportTaskProgressRequestMarshaller
implements Marshaller<Request<ReportTaskProgressRequest>, ReportTaskProgressRequest> {
    private static final OperationInfo SDK_OPERATION_BINDING = OperationInfo.builder().requestUri("/").httpMethodName(HttpMethodName.POST).hasExplicitPayloadMember(false).hasPayloadMembers(true).operationIdentifier("DataPipeline.ReportTaskProgress").serviceName("AWS Data Pipeline").build();
    private final AwsJsonProtocolFactory protocolFactory;

    public ReportTaskProgressRequestMarshaller(AwsJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<ReportTaskProgressRequest> marshall(ReportTaskProgressRequest reportTaskProgressRequest) {
        Validate.paramNotNull((Object)((Object)reportTaskProgressRequest), (String)"reportTaskProgressRequest");
        try {
            ProtocolRequestMarshaller protocolMarshaller = this.protocolFactory.createProtocolMarshaller(SDK_OPERATION_BINDING, (SdkRequest)reportTaskProgressRequest);
            protocolMarshaller.startMarshalling();
            ReportTaskProgressRequestModelMarshaller.getInstance().marshall(reportTaskProgressRequest, (ProtocolMarshaller)protocolMarshaller);
            return protocolMarshaller.finishMarshalling();
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

