/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datapipeline.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.datapipeline.model.DataPipelineRequest;
import software.amazon.awssdk.services.datapipeline.model.ParameterObject;
import software.amazon.awssdk.services.datapipeline.model.ParameterObjectListCopier;
import software.amazon.awssdk.services.datapipeline.model.ParameterValue;
import software.amazon.awssdk.services.datapipeline.model.ParameterValueListCopier;
import software.amazon.awssdk.services.datapipeline.model.PipelineObject;
import software.amazon.awssdk.services.datapipeline.model.PipelineObjectListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ValidatePipelineDefinitionRequest
extends DataPipelineRequest
implements ToCopyableBuilder<Builder, ValidatePipelineDefinitionRequest> {
    private final String pipelineId;
    private final List<PipelineObject> pipelineObjects;
    private final List<ParameterObject> parameterObjects;
    private final List<ParameterValue> parameterValues;

    private ValidatePipelineDefinitionRequest(BuilderImpl builder) {
        super(builder);
        this.pipelineId = builder.pipelineId;
        this.pipelineObjects = builder.pipelineObjects;
        this.parameterObjects = builder.parameterObjects;
        this.parameterValues = builder.parameterValues;
    }

    public String pipelineId() {
        return this.pipelineId;
    }

    public List<PipelineObject> pipelineObjects() {
        return this.pipelineObjects;
    }

    public List<ParameterObject> parameterObjects() {
        return this.parameterObjects;
    }

    public List<ParameterValue> parameterValues() {
        return this.parameterValues;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.pipelineId());
        hashCode = 31 * hashCode + Objects.hashCode(this.pipelineObjects());
        hashCode = 31 * hashCode + Objects.hashCode(this.parameterObjects());
        hashCode = 31 * hashCode + Objects.hashCode(this.parameterValues());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ValidatePipelineDefinitionRequest)) {
            return false;
        }
        ValidatePipelineDefinitionRequest other = (ValidatePipelineDefinitionRequest)((Object)obj);
        return Objects.equals(this.pipelineId(), other.pipelineId()) && Objects.equals(this.pipelineObjects(), other.pipelineObjects()) && Objects.equals(this.parameterObjects(), other.parameterObjects()) && Objects.equals(this.parameterValues(), other.parameterValues());
    }

    public String toString() {
        return ToString.builder((String)"ValidatePipelineDefinitionRequest").add("PipelineId", (Object)this.pipelineId()).add("PipelineObjects", this.pipelineObjects()).add("ParameterObjects", this.parameterObjects()).add("ParameterValues", this.parameterValues()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "pipelineId": {
                return Optional.of(clazz.cast(this.pipelineId()));
            }
            case "pipelineObjects": {
                return Optional.of(clazz.cast(this.pipelineObjects()));
            }
            case "parameterObjects": {
                return Optional.of(clazz.cast(this.parameterObjects()));
            }
            case "parameterValues": {
                return Optional.of(clazz.cast(this.parameterValues()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends DataPipelineRequest.BuilderImpl
    implements Builder {
        private String pipelineId;
        private List<PipelineObject> pipelineObjects;
        private List<ParameterObject> parameterObjects;
        private List<ParameterValue> parameterValues;

        private BuilderImpl() {
        }

        private BuilderImpl(ValidatePipelineDefinitionRequest model) {
            super(model);
            this.pipelineId(model.pipelineId);
            this.pipelineObjects(model.pipelineObjects);
            this.parameterObjects(model.parameterObjects);
            this.parameterValues(model.parameterValues);
        }

        public final String getPipelineId() {
            return this.pipelineId;
        }

        @Override
        public final Builder pipelineId(String pipelineId) {
            this.pipelineId = pipelineId;
            return this;
        }

        public final void setPipelineId(String pipelineId) {
            this.pipelineId = pipelineId;
        }

        public final Collection<PipelineObject.Builder> getPipelineObjects() {
            return this.pipelineObjects != null ? (Collection)this.pipelineObjects.stream().map(PipelineObject::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder pipelineObjects(Collection<PipelineObject> pipelineObjects) {
            this.pipelineObjects = PipelineObjectListCopier.copy(pipelineObjects);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pipelineObjects(PipelineObject ... pipelineObjects) {
            this.pipelineObjects(Arrays.asList(pipelineObjects));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pipelineObjects(Consumer<PipelineObject.Builder> ... pipelineObjects) {
            this.pipelineObjects(Stream.of(pipelineObjects).map(c -> (PipelineObject)((PipelineObject.Builder)PipelineObject.builder().apply((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setPipelineObjects(Collection<PipelineObject.BuilderImpl> pipelineObjects) {
            this.pipelineObjects = PipelineObjectListCopier.copyFromBuilder(pipelineObjects);
        }

        public final Collection<ParameterObject.Builder> getParameterObjects() {
            return this.parameterObjects != null ? (Collection)this.parameterObjects.stream().map(ParameterObject::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder parameterObjects(Collection<ParameterObject> parameterObjects) {
            this.parameterObjects = ParameterObjectListCopier.copy(parameterObjects);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameterObjects(ParameterObject ... parameterObjects) {
            this.parameterObjects(Arrays.asList(parameterObjects));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameterObjects(Consumer<ParameterObject.Builder> ... parameterObjects) {
            this.parameterObjects(Stream.of(parameterObjects).map(c -> (ParameterObject)((ParameterObject.Builder)ParameterObject.builder().apply((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setParameterObjects(Collection<ParameterObject.BuilderImpl> parameterObjects) {
            this.parameterObjects = ParameterObjectListCopier.copyFromBuilder(parameterObjects);
        }

        public final Collection<ParameterValue.Builder> getParameterValues() {
            return this.parameterValues != null ? (Collection)this.parameterValues.stream().map(ParameterValue::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder parameterValues(Collection<ParameterValue> parameterValues) {
            this.parameterValues = ParameterValueListCopier.copy(parameterValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameterValues(ParameterValue ... parameterValues) {
            this.parameterValues(Arrays.asList(parameterValues));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameterValues(Consumer<ParameterValue.Builder> ... parameterValues) {
            this.parameterValues(Stream.of(parameterValues).map(c -> (ParameterValue)((ParameterValue.Builder)ParameterValue.builder().apply((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setParameterValues(Collection<ParameterValue.BuilderImpl> parameterValues) {
            this.parameterValues = ParameterValueListCopier.copyFromBuilder(parameterValues);
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public ValidatePipelineDefinitionRequest build() {
            return new ValidatePipelineDefinitionRequest(this);
        }
    }

    public static interface Builder
    extends DataPipelineRequest.Builder,
    CopyableBuilder<Builder, ValidatePipelineDefinitionRequest> {
        public Builder pipelineId(String var1);

        public Builder pipelineObjects(Collection<PipelineObject> var1);

        public Builder pipelineObjects(PipelineObject ... var1);

        public Builder pipelineObjects(Consumer<PipelineObject.Builder> ... var1);

        public Builder parameterObjects(Collection<ParameterObject> var1);

        public Builder parameterObjects(ParameterObject ... var1);

        public Builder parameterObjects(Consumer<ParameterObject.Builder> ... var1);

        public Builder parameterValues(Collection<ParameterValue> var1);

        public Builder parameterValues(ParameterValue ... var1);

        public Builder parameterValues(Consumer<ParameterValue.Builder> ... var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> var1);
    }
}

