/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datapipeline.model;

import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.services.datapipeline.model.Field;
import software.amazon.awssdk.services.datapipeline.model._fieldListCopier;
import software.amazon.awssdk.services.datapipeline.transform.PipelineObjectMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class PipelineObject
implements StructuredPojo,
ToCopyableBuilder<Builder, PipelineObject> {
    private final String id;
    private final String name;
    private final List<Field> fields;

    private PipelineObject(BuilderImpl builder) {
        this.id = builder.id;
        this.name = builder.name;
        this.fields = builder.fields;
    }

    public String id() {
        return this.id;
    }

    public String name() {
        return this.name;
    }

    public List<Field> fields() {
        return this.fields;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.id() == null ? 0 : this.id().hashCode());
        hashCode = 31 * hashCode + (this.name() == null ? 0 : this.name().hashCode());
        hashCode = 31 * hashCode + (this.fields() == null ? 0 : this.fields().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PipelineObject)) {
            return false;
        }
        PipelineObject other = (PipelineObject)obj;
        if (other.id() == null ^ this.id() == null) {
            return false;
        }
        if (other.id() != null && !other.id().equals(this.id())) {
            return false;
        }
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        if (other.name() != null && !other.name().equals(this.name())) {
            return false;
        }
        if (other.fields() == null ^ this.fields() == null) {
            return false;
        }
        return other.fields() == null || other.fields().equals(this.fields());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.id() != null) {
            sb.append("Id: ").append(this.id()).append(",");
        }
        if (this.name() != null) {
            sb.append("Name: ").append(this.name()).append(",");
        }
        if (this.fields() != null) {
            sb.append("Fields: ").append(this.fields()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        PipelineObjectMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String id;
        private String name;
        private List<Field> fields = new SdkInternalList();

        private BuilderImpl() {
        }

        private BuilderImpl(PipelineObject model) {
            this.setId(model.id);
            this.setName(model.name);
            this.setFields(model.fields);
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Collection<Field> getFields() {
            return this.fields;
        }

        @Override
        public final Builder fields(Collection<Field> fields) {
            this.fields = _fieldListCopier.copy(fields);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fields(Field ... fields) {
            if (this.fields == null) {
                this.fields = new SdkInternalList(fields.length);
            }
            for (Field e : fields) {
                this.fields.add(e);
            }
            return this;
        }

        public final void setFields(Collection<Field> fields) {
            this.fields = _fieldListCopier.copy(fields);
        }

        @SafeVarargs
        public final void setFields(Field ... fields) {
            if (this.fields == null) {
                this.fields = new SdkInternalList(fields.length);
            }
            for (Field e : fields) {
                this.fields.add(e);
            }
        }

        public PipelineObject build() {
            return new PipelineObject(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, PipelineObject> {
        public Builder id(String var1);

        public Builder name(String var1);

        public Builder fields(Collection<Field> var1);

        public Builder fields(Field ... var1);
    }
}

