/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datapipeline.model;

import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.services.datapipeline.model.ParameterAttribute;
import software.amazon.awssdk.services.datapipeline.model.ParameterAttributeListCopier;
import software.amazon.awssdk.services.datapipeline.transform.ParameterObjectMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ParameterObject
implements StructuredPojo,
ToCopyableBuilder<Builder, ParameterObject> {
    private final String id;
    private final List<ParameterAttribute> attributes;

    private ParameterObject(BuilderImpl builder) {
        this.id = builder.id;
        this.attributes = builder.attributes;
    }

    public String id() {
        return this.id;
    }

    public List<ParameterAttribute> attributes() {
        return this.attributes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.id() == null ? 0 : this.id().hashCode());
        hashCode = 31 * hashCode + (this.attributes() == null ? 0 : this.attributes().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ParameterObject)) {
            return false;
        }
        ParameterObject other = (ParameterObject)obj;
        if (other.id() == null ^ this.id() == null) {
            return false;
        }
        if (other.id() != null && !other.id().equals(this.id())) {
            return false;
        }
        if (other.attributes() == null ^ this.attributes() == null) {
            return false;
        }
        return other.attributes() == null || other.attributes().equals(this.attributes());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.id() != null) {
            sb.append("Id: ").append(this.id()).append(",");
        }
        if (this.attributes() != null) {
            sb.append("Attributes: ").append(this.attributes()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ParameterObjectMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String id;
        private List<ParameterAttribute> attributes = new SdkInternalList();

        private BuilderImpl() {
        }

        private BuilderImpl(ParameterObject model) {
            this.setId(model.id);
            this.setAttributes(model.attributes);
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final Collection<ParameterAttribute> getAttributes() {
            return this.attributes;
        }

        @Override
        public final Builder attributes(Collection<ParameterAttribute> attributes) {
            this.attributes = ParameterAttributeListCopier.copy(attributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributes(ParameterAttribute ... attributes) {
            if (this.attributes == null) {
                this.attributes = new SdkInternalList(attributes.length);
            }
            for (ParameterAttribute e : attributes) {
                this.attributes.add(e);
            }
            return this;
        }

        public final void setAttributes(Collection<ParameterAttribute> attributes) {
            this.attributes = ParameterAttributeListCopier.copy(attributes);
        }

        @SafeVarargs
        public final void setAttributes(ParameterAttribute ... attributes) {
            if (this.attributes == null) {
                this.attributes = new SdkInternalList(attributes.length);
            }
            for (ParameterAttribute e : attributes) {
                this.attributes.add(e);
            }
        }

        public ParameterObject build() {
            return new ParameterObject(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ParameterObject> {
        public Builder id(String var1);

        public Builder attributes(Collection<ParameterAttribute> var1);

        public Builder attributes(ParameterAttribute ... var1);
    }
}

