/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datapipeline.model;

import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.services.datapipeline.model._idListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribePipelinesRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, DescribePipelinesRequest> {
    private final List<String> pipelineIds;

    private DescribePipelinesRequest(BuilderImpl builder) {
        this.pipelineIds = builder.pipelineIds;
    }

    public List<String> pipelineIds() {
        return this.pipelineIds;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.pipelineIds() == null ? 0 : this.pipelineIds().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribePipelinesRequest)) {
            return false;
        }
        DescribePipelinesRequest other = (DescribePipelinesRequest)((Object)obj);
        if (other.pipelineIds() == null ^ this.pipelineIds() == null) {
            return false;
        }
        return other.pipelineIds() == null || other.pipelineIds().equals(this.pipelineIds());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.pipelineIds() != null) {
            sb.append("PipelineIds: ").append(this.pipelineIds()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<String> pipelineIds = new SdkInternalList();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribePipelinesRequest model) {
            this.setPipelineIds(model.pipelineIds);
        }

        public final Collection<String> getPipelineIds() {
            return this.pipelineIds;
        }

        @Override
        public final Builder pipelineIds(Collection<String> pipelineIds) {
            this.pipelineIds = _idListCopier.copy(pipelineIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pipelineIds(String ... pipelineIds) {
            if (this.pipelineIds == null) {
                this.pipelineIds = new SdkInternalList(pipelineIds.length);
            }
            for (String e : pipelineIds) {
                this.pipelineIds.add(e);
            }
            return this;
        }

        public final void setPipelineIds(Collection<String> pipelineIds) {
            this.pipelineIds = _idListCopier.copy(pipelineIds);
        }

        @SafeVarargs
        public final void setPipelineIds(String ... pipelineIds) {
            if (this.pipelineIds == null) {
                this.pipelineIds = new SdkInternalList(pipelineIds.length);
            }
            for (String e : pipelineIds) {
                this.pipelineIds.add(e);
            }
        }

        public DescribePipelinesRequest build() {
            return new DescribePipelinesRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribePipelinesRequest> {
        public Builder pipelineIds(Collection<String> var1);

        public Builder pipelineIds(String ... var1);
    }
}

