/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dataexchange.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum AcceptanceStateFilterValue {
    PENDING_RECEIVER_ACCEPTANCE("PENDING_RECEIVER_ACCEPTANCE"),
    ACCEPTED("ACCEPTED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, AcceptanceStateFilterValue> VALUE_MAP;
    private final String value;

    private AcceptanceStateFilterValue(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static AcceptanceStateFilterValue fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<AcceptanceStateFilterValue> knownValues() {
        EnumSet<AcceptanceStateFilterValue> knownValues = EnumSet.allOf(AcceptanceStateFilterValue.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(AcceptanceStateFilterValue.class, AcceptanceStateFilterValue::toString);
    }
}

