/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dataexchange;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.dataexchange.DataExchangeClient;
import software.amazon.awssdk.services.dataexchange.DataExchangeClientBuilder;
import software.amazon.awssdk.services.dataexchange.DataExchangeServiceClientConfiguration;
import software.amazon.awssdk.services.dataexchange.DefaultDataExchangeBaseClientBuilder;
import software.amazon.awssdk.services.dataexchange.DefaultDataExchangeClient;
import software.amazon.awssdk.services.dataexchange.endpoints.DataExchangeEndpointProvider;

@SdkInternalApi
final class DefaultDataExchangeClientBuilder
extends DefaultDataExchangeBaseClientBuilder<DataExchangeClientBuilder, DataExchangeClient>
implements DataExchangeClientBuilder {
    DefaultDataExchangeClientBuilder() {
    }

    @Override
    public DefaultDataExchangeClientBuilder endpointProvider(DataExchangeEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final DataExchangeClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultDataExchangeClientBuilder.validateClientOptions(clientConfiguration);
        URI endpointOverride = null;
        if (clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        DataExchangeServiceClientConfiguration serviceClientConfiguration = DataExchangeServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfiguration.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).build();
        return new DefaultDataExchangeClient(serviceClientConfiguration, clientConfiguration);
    }
}

