/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dataexchange.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The response details.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ImportAssetFromApiGatewayApiResponseDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<ImportAssetFromApiGatewayApiResponseDetails.Builder, ImportAssetFromApiGatewayApiResponseDetails> {
    private static final SdkField<String> API_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ApiDescription").getter(getter(ImportAssetFromApiGatewayApiResponseDetails::apiDescription))
            .setter(setter(Builder::apiDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApiDescription").build()).build();

    private static final SdkField<String> API_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("ApiId")
            .getter(getter(ImportAssetFromApiGatewayApiResponseDetails::apiId)).setter(setter(Builder::apiId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApiId").build()).build();

    private static final SdkField<String> API_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("ApiKey")
            .getter(getter(ImportAssetFromApiGatewayApiResponseDetails::apiKey)).setter(setter(Builder::apiKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApiKey").build()).build();

    private static final SdkField<String> API_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ApiName").getter(getter(ImportAssetFromApiGatewayApiResponseDetails::apiName))
            .setter(setter(Builder::apiName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApiName").build()).build();

    private static final SdkField<String> API_SPECIFICATION_MD5_HASH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ApiSpecificationMd5Hash")
            .getter(getter(ImportAssetFromApiGatewayApiResponseDetails::apiSpecificationMd5Hash))
            .setter(setter(Builder::apiSpecificationMd5Hash))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApiSpecificationMd5Hash").build())
            .build();

    private static final SdkField<String> API_SPECIFICATION_UPLOAD_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ApiSpecificationUploadUrl")
            .getter(getter(ImportAssetFromApiGatewayApiResponseDetails::apiSpecificationUploadUrl))
            .setter(setter(Builder::apiSpecificationUploadUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApiSpecificationUploadUrl").build())
            .build();

    private static final SdkField<Instant> API_SPECIFICATION_UPLOAD_URL_EXPIRES_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("ApiSpecificationUploadUrlExpiresAt")
            .getter(getter(ImportAssetFromApiGatewayApiResponseDetails::apiSpecificationUploadUrlExpiresAt))
            .setter(setter(Builder::apiSpecificationUploadUrlExpiresAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApiSpecificationUploadUrlExpiresAt")
                    .build(), TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> DATA_SET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DataSetId").getter(getter(ImportAssetFromApiGatewayApiResponseDetails::dataSetId))
            .setter(setter(Builder::dataSetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSetId").build()).build();

    private static final SdkField<String> PROTOCOL_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProtocolType").getter(getter(ImportAssetFromApiGatewayApiResponseDetails::protocolTypeAsString))
            .setter(setter(Builder::protocolType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProtocolType").build()).build();

    private static final SdkField<String> REVISION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RevisionId").getter(getter(ImportAssetFromApiGatewayApiResponseDetails::revisionId))
            .setter(setter(Builder::revisionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RevisionId").build()).build();

    private static final SdkField<String> STAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Stage")
            .getter(getter(ImportAssetFromApiGatewayApiResponseDetails::stage)).setter(setter(Builder::stage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Stage").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(API_DESCRIPTION_FIELD, API_ID_FIELD, API_KEY_FIELD, API_NAME_FIELD, API_SPECIFICATION_MD5_HASH_FIELD,
                    API_SPECIFICATION_UPLOAD_URL_FIELD, API_SPECIFICATION_UPLOAD_URL_EXPIRES_AT_FIELD, DATA_SET_ID_FIELD,
                    PROTOCOL_TYPE_FIELD, REVISION_ID_FIELD, STAGE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String apiDescription;

    private final String apiId;

    private final String apiKey;

    private final String apiName;

    private final String apiSpecificationMd5Hash;

    private final String apiSpecificationUploadUrl;

    private final Instant apiSpecificationUploadUrlExpiresAt;

    private final String dataSetId;

    private final String protocolType;

    private final String revisionId;

    private final String stage;

    private ImportAssetFromApiGatewayApiResponseDetails(BuilderImpl builder) {
        this.apiDescription = builder.apiDescription;
        this.apiId = builder.apiId;
        this.apiKey = builder.apiKey;
        this.apiName = builder.apiName;
        this.apiSpecificationMd5Hash = builder.apiSpecificationMd5Hash;
        this.apiSpecificationUploadUrl = builder.apiSpecificationUploadUrl;
        this.apiSpecificationUploadUrlExpiresAt = builder.apiSpecificationUploadUrlExpiresAt;
        this.dataSetId = builder.dataSetId;
        this.protocolType = builder.protocolType;
        this.revisionId = builder.revisionId;
        this.stage = builder.stage;
    }

    /**
     * <p>
     * The API description.
     * </p>
     * 
     * @return The API description.
     */
    public final String apiDescription() {
        return apiDescription;
    }

    /**
     * <p>
     * The API ID.
     * </p>
     * 
     * @return The API ID.
     */
    public final String apiId() {
        return apiId;
    }

    /**
     * <p>
     * The API key.
     * </p>
     * 
     * @return The API key.
     */
    public final String apiKey() {
        return apiKey;
    }

    /**
     * <p>
     * The API name.
     * </p>
     * 
     * @return The API name.
     */
    public final String apiName() {
        return apiName;
    }

    /**
     * <p>
     * The Base64-encoded Md5 hash for the API asset, used to ensure the integrity of the API at that location.
     * </p>
     * 
     * @return The Base64-encoded Md5 hash for the API asset, used to ensure the integrity of the API at that location.
     */
    public final String apiSpecificationMd5Hash() {
        return apiSpecificationMd5Hash;
    }

    /**
     * <p>
     * The upload URL of the API specification.
     * </p>
     * 
     * @return The upload URL of the API specification.
     */
    public final String apiSpecificationUploadUrl() {
        return apiSpecificationUploadUrl;
    }

    /**
     * <p>
     * The date and time that the upload URL expires, in ISO 8601 format.
     * </p>
     * 
     * @return The date and time that the upload URL expires, in ISO 8601 format.
     */
    public final Instant apiSpecificationUploadUrlExpiresAt() {
        return apiSpecificationUploadUrlExpiresAt;
    }

    /**
     * <p>
     * The data set ID.
     * </p>
     * 
     * @return The data set ID.
     */
    public final String dataSetId() {
        return dataSetId;
    }

    /**
     * <p>
     * The protocol type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #protocolType} will
     * return {@link ProtocolType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #protocolTypeAsString}.
     * </p>
     * 
     * @return The protocol type.
     * @see ProtocolType
     */
    public final ProtocolType protocolType() {
        return ProtocolType.fromValue(protocolType);
    }

    /**
     * <p>
     * The protocol type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #protocolType} will
     * return {@link ProtocolType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #protocolTypeAsString}.
     * </p>
     * 
     * @return The protocol type.
     * @see ProtocolType
     */
    public final String protocolTypeAsString() {
        return protocolType;
    }

    /**
     * <p>
     * The revision ID.
     * </p>
     * 
     * @return The revision ID.
     */
    public final String revisionId() {
        return revisionId;
    }

    /**
     * <p>
     * The API stage.
     * </p>
     * 
     * @return The API stage.
     */
    public final String stage() {
        return stage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(apiDescription());
        hashCode = 31 * hashCode + Objects.hashCode(apiId());
        hashCode = 31 * hashCode + Objects.hashCode(apiKey());
        hashCode = 31 * hashCode + Objects.hashCode(apiName());
        hashCode = 31 * hashCode + Objects.hashCode(apiSpecificationMd5Hash());
        hashCode = 31 * hashCode + Objects.hashCode(apiSpecificationUploadUrl());
        hashCode = 31 * hashCode + Objects.hashCode(apiSpecificationUploadUrlExpiresAt());
        hashCode = 31 * hashCode + Objects.hashCode(dataSetId());
        hashCode = 31 * hashCode + Objects.hashCode(protocolTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(revisionId());
        hashCode = 31 * hashCode + Objects.hashCode(stage());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImportAssetFromApiGatewayApiResponseDetails)) {
            return false;
        }
        ImportAssetFromApiGatewayApiResponseDetails other = (ImportAssetFromApiGatewayApiResponseDetails) obj;
        return Objects.equals(apiDescription(), other.apiDescription()) && Objects.equals(apiId(), other.apiId())
                && Objects.equals(apiKey(), other.apiKey()) && Objects.equals(apiName(), other.apiName())
                && Objects.equals(apiSpecificationMd5Hash(), other.apiSpecificationMd5Hash())
                && Objects.equals(apiSpecificationUploadUrl(), other.apiSpecificationUploadUrl())
                && Objects.equals(apiSpecificationUploadUrlExpiresAt(), other.apiSpecificationUploadUrlExpiresAt())
                && Objects.equals(dataSetId(), other.dataSetId())
                && Objects.equals(protocolTypeAsString(), other.protocolTypeAsString())
                && Objects.equals(revisionId(), other.revisionId()) && Objects.equals(stage(), other.stage());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ImportAssetFromApiGatewayApiResponseDetails").add("ApiDescription", apiDescription())
                .add("ApiId", apiId()).add("ApiKey", apiKey()).add("ApiName", apiName())
                .add("ApiSpecificationMd5Hash", apiSpecificationMd5Hash())
                .add("ApiSpecificationUploadUrl", apiSpecificationUploadUrl())
                .add("ApiSpecificationUploadUrlExpiresAt", apiSpecificationUploadUrlExpiresAt()).add("DataSetId", dataSetId())
                .add("ProtocolType", protocolTypeAsString()).add("RevisionId", revisionId()).add("Stage", stage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ApiDescription":
            return Optional.ofNullable(clazz.cast(apiDescription()));
        case "ApiId":
            return Optional.ofNullable(clazz.cast(apiId()));
        case "ApiKey":
            return Optional.ofNullable(clazz.cast(apiKey()));
        case "ApiName":
            return Optional.ofNullable(clazz.cast(apiName()));
        case "ApiSpecificationMd5Hash":
            return Optional.ofNullable(clazz.cast(apiSpecificationMd5Hash()));
        case "ApiSpecificationUploadUrl":
            return Optional.ofNullable(clazz.cast(apiSpecificationUploadUrl()));
        case "ApiSpecificationUploadUrlExpiresAt":
            return Optional.ofNullable(clazz.cast(apiSpecificationUploadUrlExpiresAt()));
        case "DataSetId":
            return Optional.ofNullable(clazz.cast(dataSetId()));
        case "ProtocolType":
            return Optional.ofNullable(clazz.cast(protocolTypeAsString()));
        case "RevisionId":
            return Optional.ofNullable(clazz.cast(revisionId()));
        case "Stage":
            return Optional.ofNullable(clazz.cast(stage()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ImportAssetFromApiGatewayApiResponseDetails, T> g) {
        return obj -> g.apply((ImportAssetFromApiGatewayApiResponseDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ImportAssetFromApiGatewayApiResponseDetails> {
        /**
         * <p>
         * The API description.
         * </p>
         * 
         * @param apiDescription
         *        The API description.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder apiDescription(String apiDescription);

        /**
         * <p>
         * The API ID.
         * </p>
         * 
         * @param apiId
         *        The API ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder apiId(String apiId);

        /**
         * <p>
         * The API key.
         * </p>
         * 
         * @param apiKey
         *        The API key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder apiKey(String apiKey);

        /**
         * <p>
         * The API name.
         * </p>
         * 
         * @param apiName
         *        The API name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder apiName(String apiName);

        /**
         * <p>
         * The Base64-encoded Md5 hash for the API asset, used to ensure the integrity of the API at that location.
         * </p>
         * 
         * @param apiSpecificationMd5Hash
         *        The Base64-encoded Md5 hash for the API asset, used to ensure the integrity of the API at that
         *        location.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder apiSpecificationMd5Hash(String apiSpecificationMd5Hash);

        /**
         * <p>
         * The upload URL of the API specification.
         * </p>
         * 
         * @param apiSpecificationUploadUrl
         *        The upload URL of the API specification.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder apiSpecificationUploadUrl(String apiSpecificationUploadUrl);

        /**
         * <p>
         * The date and time that the upload URL expires, in ISO 8601 format.
         * </p>
         * 
         * @param apiSpecificationUploadUrlExpiresAt
         *        The date and time that the upload URL expires, in ISO 8601 format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder apiSpecificationUploadUrlExpiresAt(Instant apiSpecificationUploadUrlExpiresAt);

        /**
         * <p>
         * The data set ID.
         * </p>
         * 
         * @param dataSetId
         *        The data set ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSetId(String dataSetId);

        /**
         * <p>
         * The protocol type.
         * </p>
         * 
         * @param protocolType
         *        The protocol type.
         * @see ProtocolType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProtocolType
         */
        Builder protocolType(String protocolType);

        /**
         * <p>
         * The protocol type.
         * </p>
         * 
         * @param protocolType
         *        The protocol type.
         * @see ProtocolType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProtocolType
         */
        Builder protocolType(ProtocolType protocolType);

        /**
         * <p>
         * The revision ID.
         * </p>
         * 
         * @param revisionId
         *        The revision ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder revisionId(String revisionId);

        /**
         * <p>
         * The API stage.
         * </p>
         * 
         * @param stage
         *        The API stage.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stage(String stage);
    }

    static final class BuilderImpl implements Builder {
        private String apiDescription;

        private String apiId;

        private String apiKey;

        private String apiName;

        private String apiSpecificationMd5Hash;

        private String apiSpecificationUploadUrl;

        private Instant apiSpecificationUploadUrlExpiresAt;

        private String dataSetId;

        private String protocolType;

        private String revisionId;

        private String stage;

        private BuilderImpl() {
        }

        private BuilderImpl(ImportAssetFromApiGatewayApiResponseDetails model) {
            apiDescription(model.apiDescription);
            apiId(model.apiId);
            apiKey(model.apiKey);
            apiName(model.apiName);
            apiSpecificationMd5Hash(model.apiSpecificationMd5Hash);
            apiSpecificationUploadUrl(model.apiSpecificationUploadUrl);
            apiSpecificationUploadUrlExpiresAt(model.apiSpecificationUploadUrlExpiresAt);
            dataSetId(model.dataSetId);
            protocolType(model.protocolType);
            revisionId(model.revisionId);
            stage(model.stage);
        }

        public final String getApiDescription() {
            return apiDescription;
        }

        public final void setApiDescription(String apiDescription) {
            this.apiDescription = apiDescription;
        }

        @Override
        public final Builder apiDescription(String apiDescription) {
            this.apiDescription = apiDescription;
            return this;
        }

        public final String getApiId() {
            return apiId;
        }

        public final void setApiId(String apiId) {
            this.apiId = apiId;
        }

        @Override
        public final Builder apiId(String apiId) {
            this.apiId = apiId;
            return this;
        }

        public final String getApiKey() {
            return apiKey;
        }

        public final void setApiKey(String apiKey) {
            this.apiKey = apiKey;
        }

        @Override
        public final Builder apiKey(String apiKey) {
            this.apiKey = apiKey;
            return this;
        }

        public final String getApiName() {
            return apiName;
        }

        public final void setApiName(String apiName) {
            this.apiName = apiName;
        }

        @Override
        public final Builder apiName(String apiName) {
            this.apiName = apiName;
            return this;
        }

        public final String getApiSpecificationMd5Hash() {
            return apiSpecificationMd5Hash;
        }

        public final void setApiSpecificationMd5Hash(String apiSpecificationMd5Hash) {
            this.apiSpecificationMd5Hash = apiSpecificationMd5Hash;
        }

        @Override
        public final Builder apiSpecificationMd5Hash(String apiSpecificationMd5Hash) {
            this.apiSpecificationMd5Hash = apiSpecificationMd5Hash;
            return this;
        }

        public final String getApiSpecificationUploadUrl() {
            return apiSpecificationUploadUrl;
        }

        public final void setApiSpecificationUploadUrl(String apiSpecificationUploadUrl) {
            this.apiSpecificationUploadUrl = apiSpecificationUploadUrl;
        }

        @Override
        public final Builder apiSpecificationUploadUrl(String apiSpecificationUploadUrl) {
            this.apiSpecificationUploadUrl = apiSpecificationUploadUrl;
            return this;
        }

        public final Instant getApiSpecificationUploadUrlExpiresAt() {
            return apiSpecificationUploadUrlExpiresAt;
        }

        public final void setApiSpecificationUploadUrlExpiresAt(Instant apiSpecificationUploadUrlExpiresAt) {
            this.apiSpecificationUploadUrlExpiresAt = apiSpecificationUploadUrlExpiresAt;
        }

        @Override
        public final Builder apiSpecificationUploadUrlExpiresAt(Instant apiSpecificationUploadUrlExpiresAt) {
            this.apiSpecificationUploadUrlExpiresAt = apiSpecificationUploadUrlExpiresAt;
            return this;
        }

        public final String getDataSetId() {
            return dataSetId;
        }

        public final void setDataSetId(String dataSetId) {
            this.dataSetId = dataSetId;
        }

        @Override
        public final Builder dataSetId(String dataSetId) {
            this.dataSetId = dataSetId;
            return this;
        }

        public final String getProtocolType() {
            return protocolType;
        }

        public final void setProtocolType(String protocolType) {
            this.protocolType = protocolType;
        }

        @Override
        public final Builder protocolType(String protocolType) {
            this.protocolType = protocolType;
            return this;
        }

        @Override
        public final Builder protocolType(ProtocolType protocolType) {
            this.protocolType(protocolType == null ? null : protocolType.toString());
            return this;
        }

        public final String getRevisionId() {
            return revisionId;
        }

        public final void setRevisionId(String revisionId) {
            this.revisionId = revisionId;
        }

        @Override
        public final Builder revisionId(String revisionId) {
            this.revisionId = revisionId;
            return this;
        }

        public final String getStage() {
            return stage;
        }

        public final void setStage(String stage) {
            this.stage = stage;
        }

        @Override
        public final Builder stage(String stage) {
            this.stage = stage;
            return this;
        }

        @Override
        public ImportAssetFromApiGatewayApiResponseDetails build() {
            return new ImportAssetFromApiGatewayApiResponseDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
