/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dataexchange.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details about the export revisions to Amazon S3 response.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ExportRevisionsToS3ResponseDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<ExportRevisionsToS3ResponseDetails.Builder, ExportRevisionsToS3ResponseDetails> {
    private static final SdkField<String> DATA_SET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DataSetId").getter(getter(ExportRevisionsToS3ResponseDetails::dataSetId))
            .setter(setter(Builder::dataSetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSetId").build()).build();

    private static final SdkField<ExportServerSideEncryption> ENCRYPTION_FIELD = SdkField
            .<ExportServerSideEncryption> builder(MarshallingType.SDK_POJO).memberName("Encryption")
            .getter(getter(ExportRevisionsToS3ResponseDetails::encryption)).setter(setter(Builder::encryption))
            .constructor(ExportServerSideEncryption::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Encryption").build()).build();

    private static final SdkField<List<RevisionDestinationEntry>> REVISION_DESTINATIONS_FIELD = SdkField
            .<List<RevisionDestinationEntry>> builder(MarshallingType.LIST)
            .memberName("RevisionDestinations")
            .getter(getter(ExportRevisionsToS3ResponseDetails::revisionDestinations))
            .setter(setter(Builder::revisionDestinations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RevisionDestinations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RevisionDestinationEntry> builder(MarshallingType.SDK_POJO)
                                            .constructor(RevisionDestinationEntry::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> EVENT_ACTION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EventActionArn").getter(getter(ExportRevisionsToS3ResponseDetails::eventActionArn))
            .setter(setter(Builder::eventActionArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventActionArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_SET_ID_FIELD,
            ENCRYPTION_FIELD, REVISION_DESTINATIONS_FIELD, EVENT_ACTION_ARN_FIELD));

    private static final long serialVersionUID = 1L;

    private final String dataSetId;

    private final ExportServerSideEncryption encryption;

    private final List<RevisionDestinationEntry> revisionDestinations;

    private final String eventActionArn;

    private ExportRevisionsToS3ResponseDetails(BuilderImpl builder) {
        this.dataSetId = builder.dataSetId;
        this.encryption = builder.encryption;
        this.revisionDestinations = builder.revisionDestinations;
        this.eventActionArn = builder.eventActionArn;
    }

    /**
     * <p>
     * The unique identifier for the data set associated with this export job.
     * </p>
     * 
     * @return The unique identifier for the data set associated with this export job.
     */
    public final String dataSetId() {
        return dataSetId;
    }

    /**
     * <p>
     * Encryption configuration of the export job.
     * </p>
     * 
     * @return Encryption configuration of the export job.
     */
    public final ExportServerSideEncryption encryption() {
        return encryption;
    }

    /**
     * For responses, this returns true if the service returned a value for the RevisionDestinations property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasRevisionDestinations() {
        return revisionDestinations != null && !(revisionDestinations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The destination in Amazon S3 where the revision is exported.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRevisionDestinations} method.
     * </p>
     * 
     * @return The destination in Amazon S3 where the revision is exported.
     */
    public final List<RevisionDestinationEntry> revisionDestinations() {
        return revisionDestinations;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the event action.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the event action.
     */
    public final String eventActionArn() {
        return eventActionArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dataSetId());
        hashCode = 31 * hashCode + Objects.hashCode(encryption());
        hashCode = 31 * hashCode + Objects.hashCode(hasRevisionDestinations() ? revisionDestinations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(eventActionArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExportRevisionsToS3ResponseDetails)) {
            return false;
        }
        ExportRevisionsToS3ResponseDetails other = (ExportRevisionsToS3ResponseDetails) obj;
        return Objects.equals(dataSetId(), other.dataSetId()) && Objects.equals(encryption(), other.encryption())
                && hasRevisionDestinations() == other.hasRevisionDestinations()
                && Objects.equals(revisionDestinations(), other.revisionDestinations())
                && Objects.equals(eventActionArn(), other.eventActionArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ExportRevisionsToS3ResponseDetails").add("DataSetId", dataSetId())
                .add("Encryption", encryption())
                .add("RevisionDestinations", hasRevisionDestinations() ? revisionDestinations() : null)
                .add("EventActionArn", eventActionArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DataSetId":
            return Optional.ofNullable(clazz.cast(dataSetId()));
        case "Encryption":
            return Optional.ofNullable(clazz.cast(encryption()));
        case "RevisionDestinations":
            return Optional.ofNullable(clazz.cast(revisionDestinations()));
        case "EventActionArn":
            return Optional.ofNullable(clazz.cast(eventActionArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ExportRevisionsToS3ResponseDetails, T> g) {
        return obj -> g.apply((ExportRevisionsToS3ResponseDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ExportRevisionsToS3ResponseDetails> {
        /**
         * <p>
         * The unique identifier for the data set associated with this export job.
         * </p>
         * 
         * @param dataSetId
         *        The unique identifier for the data set associated with this export job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSetId(String dataSetId);

        /**
         * <p>
         * Encryption configuration of the export job.
         * </p>
         * 
         * @param encryption
         *        Encryption configuration of the export job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encryption(ExportServerSideEncryption encryption);

        /**
         * <p>
         * Encryption configuration of the export job.
         * </p>
         * This is a convenience method that creates an instance of the {@link ExportServerSideEncryption.Builder}
         * avoiding the need to create one manually via {@link ExportServerSideEncryption#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ExportServerSideEncryption.Builder#build()} is called immediately
         * and its result is passed to {@link #encryption(ExportServerSideEncryption)}.
         * 
         * @param encryption
         *        a consumer that will call methods on {@link ExportServerSideEncryption.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #encryption(ExportServerSideEncryption)
         */
        default Builder encryption(Consumer<ExportServerSideEncryption.Builder> encryption) {
            return encryption(ExportServerSideEncryption.builder().applyMutation(encryption).build());
        }

        /**
         * <p>
         * The destination in Amazon S3 where the revision is exported.
         * </p>
         * 
         * @param revisionDestinations
         *        The destination in Amazon S3 where the revision is exported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder revisionDestinations(Collection<RevisionDestinationEntry> revisionDestinations);

        /**
         * <p>
         * The destination in Amazon S3 where the revision is exported.
         * </p>
         * 
         * @param revisionDestinations
         *        The destination in Amazon S3 where the revision is exported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder revisionDestinations(RevisionDestinationEntry... revisionDestinations);

        /**
         * <p>
         * The destination in Amazon S3 where the revision is exported.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.dataexchange.model.RevisionDestinationEntry.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.dataexchange.model.RevisionDestinationEntry#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.dataexchange.model.RevisionDestinationEntry.Builder#build()} is called
         * immediately and its result is passed to {@link #revisionDestinations(List<RevisionDestinationEntry>)}.
         * 
         * @param revisionDestinations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.dataexchange.model.RevisionDestinationEntry.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #revisionDestinations(java.util.Collection<RevisionDestinationEntry>)
         */
        Builder revisionDestinations(Consumer<RevisionDestinationEntry.Builder>... revisionDestinations);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the event action.
         * </p>
         * 
         * @param eventActionArn
         *        The Amazon Resource Name (ARN) of the event action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventActionArn(String eventActionArn);
    }

    static final class BuilderImpl implements Builder {
        private String dataSetId;

        private ExportServerSideEncryption encryption;

        private List<RevisionDestinationEntry> revisionDestinations = DefaultSdkAutoConstructList.getInstance();

        private String eventActionArn;

        private BuilderImpl() {
        }

        private BuilderImpl(ExportRevisionsToS3ResponseDetails model) {
            dataSetId(model.dataSetId);
            encryption(model.encryption);
            revisionDestinations(model.revisionDestinations);
            eventActionArn(model.eventActionArn);
        }

        public final String getDataSetId() {
            return dataSetId;
        }

        public final void setDataSetId(String dataSetId) {
            this.dataSetId = dataSetId;
        }

        @Override
        public final Builder dataSetId(String dataSetId) {
            this.dataSetId = dataSetId;
            return this;
        }

        public final ExportServerSideEncryption.Builder getEncryption() {
            return encryption != null ? encryption.toBuilder() : null;
        }

        public final void setEncryption(ExportServerSideEncryption.BuilderImpl encryption) {
            this.encryption = encryption != null ? encryption.build() : null;
        }

        @Override
        public final Builder encryption(ExportServerSideEncryption encryption) {
            this.encryption = encryption;
            return this;
        }

        public final List<RevisionDestinationEntry.Builder> getRevisionDestinations() {
            List<RevisionDestinationEntry.Builder> result = ListOfRevisionDestinationEntryCopier
                    .copyToBuilder(this.revisionDestinations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRevisionDestinations(Collection<RevisionDestinationEntry.BuilderImpl> revisionDestinations) {
            this.revisionDestinations = ListOfRevisionDestinationEntryCopier.copyFromBuilder(revisionDestinations);
        }

        @Override
        public final Builder revisionDestinations(Collection<RevisionDestinationEntry> revisionDestinations) {
            this.revisionDestinations = ListOfRevisionDestinationEntryCopier.copy(revisionDestinations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder revisionDestinations(RevisionDestinationEntry... revisionDestinations) {
            revisionDestinations(Arrays.asList(revisionDestinations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder revisionDestinations(Consumer<RevisionDestinationEntry.Builder>... revisionDestinations) {
            revisionDestinations(Stream.of(revisionDestinations)
                    .map(c -> RevisionDestinationEntry.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getEventActionArn() {
            return eventActionArn;
        }

        public final void setEventActionArn(String eventActionArn) {
            this.eventActionArn = eventActionArn;
        }

        @Override
        public final Builder eventActionArn(String eventActionArn) {
            this.eventActionArn = eventActionArn;
            return this;
        }

        @Override
        public ExportRevisionsToS3ResponseDetails build() {
            return new ExportRevisionsToS3ResponseDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
