/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dataexchange.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum LimitName {
    PRODUCTS_PER_ACCOUNT("Products per account"),
    DATA_SETS_PER_ACCOUNT("Data sets per account"),
    DATA_SETS_PER_PRODUCT("Data sets per product"),
    REVISIONS_PER_DATA_SET("Revisions per data set"),
    ASSETS_PER_REVISION("Assets per revision"),
    ASSETS_PER_IMPORT_JOB_FROM_AMAZON_S3("Assets per import job from Amazon S3"),
    ASSET_PER_EXPORT_JOB_FROM_AMAZON_S3("Asset per export job from Amazon S3"),
    ASSET_SIZE_IN_GB("Asset size in GB"),
    CONCURRENT_IN_PROGRESS_JOBS_TO_IMPORT_ASSETS_FROM_AMAZON_S3("Concurrent in progress jobs to import assets from Amazon S3"),
    CONCURRENT_IN_PROGRESS_JOBS_TO_IMPORT_ASSETS_FROM_A_SIGNED_URL("Concurrent in progress jobs to import assets from a signed URL"),
    CONCURRENT_IN_PROGRESS_JOBS_TO_EXPORT_ASSETS_TO_AMAZON_S3("Concurrent in progress jobs to export assets to Amazon S3"),
    CONCURRENT_IN_PROGRESS_JOBS_TO_EXPORT_ASSETS_TO_A_SIGNED_URL("Concurrent in progress jobs to export assets to a signed URL"),
    CONCURRENT_IN_PROGRESS_JOBS_TO_EXPORT_REVISIONS_TO_AMAZON_S3("Concurrent in progress jobs to export revisions to Amazon S3"),
    EVENT_ACTIONS_PER_ACCOUNT("Event actions per account"),
    AUTO_EXPORT_EVENT_ACTIONS_PER_DATA_SET("Auto export event actions per data set"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, LimitName> VALUE_MAP;
    private final String value;

    private LimitName(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static LimitName fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<LimitName> knownValues() {
        EnumSet<LimitName> knownValues = EnumSet.allOf(LimitName.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(LimitName.class, LimitName::toString);
    }
}

