/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dataexchange.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ServerSideEncryptionTypes {
    AWS_KMS("aws:kms"),
    AES256("AES256"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ServerSideEncryptionTypes> VALUE_MAP;
    private final String value;

    private ServerSideEncryptionTypes(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ServerSideEncryptionTypes fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ServerSideEncryptionTypes> knownValues() {
        EnumSet<ServerSideEncryptionTypes> knownValues = EnumSet.allOf(ServerSideEncryptionTypes.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ServerSideEncryptionTypes.class, ServerSideEncryptionTypes::toString);
    }
}

