/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dataexchange.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details of the operation to be performed by the job.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ImportAssetsFromS3RequestDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<ImportAssetsFromS3RequestDetails.Builder, ImportAssetsFromS3RequestDetails> {
    private static final SdkField<List<AssetSourceEntry>> ASSET_SOURCES_FIELD = SdkField
            .<List<AssetSourceEntry>> builder(MarshallingType.LIST)
            .memberName("AssetSources")
            .getter(getter(ImportAssetsFromS3RequestDetails::assetSources))
            .setter(setter(Builder::assetSources))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssetSources").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AssetSourceEntry> builder(MarshallingType.SDK_POJO)
                                            .constructor(AssetSourceEntry::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> DATA_SET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DataSetId").getter(getter(ImportAssetsFromS3RequestDetails::dataSetId))
            .setter(setter(Builder::dataSetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSetId").build()).build();

    private static final SdkField<String> REVISION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RevisionId").getter(getter(ImportAssetsFromS3RequestDetails::revisionId))
            .setter(setter(Builder::revisionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RevisionId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSET_SOURCES_FIELD,
            DATA_SET_ID_FIELD, REVISION_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<AssetSourceEntry> assetSources;

    private final String dataSetId;

    private final String revisionId;

    private ImportAssetsFromS3RequestDetails(BuilderImpl builder) {
        this.assetSources = builder.assetSources;
        this.dataSetId = builder.dataSetId;
        this.revisionId = builder.revisionId;
    }

    /**
     * Returns true if the AssetSources property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasAssetSources() {
        return assetSources != null && !(assetSources instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Is a list of S3 bucket and object key pairs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAssetSources()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Is a list of S3 bucket and object key pairs.
     */
    public final List<AssetSourceEntry> assetSources() {
        return assetSources;
    }

    /**
     * <p>
     * The unique identifier for the data set associated with this import job.
     * </p>
     * 
     * @return The unique identifier for the data set associated with this import job.
     */
    public final String dataSetId() {
        return dataSetId;
    }

    /**
     * <p>
     * The unique identifier for the revision associated with this import request.
     * </p>
     * 
     * @return The unique identifier for the revision associated with this import request.
     */
    public final String revisionId() {
        return revisionId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasAssetSources() ? assetSources() : null);
        hashCode = 31 * hashCode + Objects.hashCode(dataSetId());
        hashCode = 31 * hashCode + Objects.hashCode(revisionId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImportAssetsFromS3RequestDetails)) {
            return false;
        }
        ImportAssetsFromS3RequestDetails other = (ImportAssetsFromS3RequestDetails) obj;
        return hasAssetSources() == other.hasAssetSources() && Objects.equals(assetSources(), other.assetSources())
                && Objects.equals(dataSetId(), other.dataSetId()) && Objects.equals(revisionId(), other.revisionId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ImportAssetsFromS3RequestDetails")
                .add("AssetSources", hasAssetSources() ? assetSources() : null).add("DataSetId", dataSetId())
                .add("RevisionId", revisionId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AssetSources":
            return Optional.ofNullable(clazz.cast(assetSources()));
        case "DataSetId":
            return Optional.ofNullable(clazz.cast(dataSetId()));
        case "RevisionId":
            return Optional.ofNullable(clazz.cast(revisionId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ImportAssetsFromS3RequestDetails, T> g) {
        return obj -> g.apply((ImportAssetsFromS3RequestDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ImportAssetsFromS3RequestDetails> {
        /**
         * <p>
         * Is a list of S3 bucket and object key pairs.
         * </p>
         * 
         * @param assetSources
         *        Is a list of S3 bucket and object key pairs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assetSources(Collection<AssetSourceEntry> assetSources);

        /**
         * <p>
         * Is a list of S3 bucket and object key pairs.
         * </p>
         * 
         * @param assetSources
         *        Is a list of S3 bucket and object key pairs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assetSources(AssetSourceEntry... assetSources);

        /**
         * <p>
         * Is a list of S3 bucket and object key pairs.
         * </p>
         * This is a convenience that creates an instance of the {@link List<AssetSourceEntry>.Builder} avoiding the
         * need to create one manually via {@link List<AssetSourceEntry>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<AssetSourceEntry>.Builder#build()} is called immediately and
         * its result is passed to {@link #assetSources(List<AssetSourceEntry>)}.
         * 
         * @param assetSources
         *        a consumer that will call methods on {@link List<AssetSourceEntry>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #assetSources(List<AssetSourceEntry>)
         */
        Builder assetSources(Consumer<AssetSourceEntry.Builder>... assetSources);

        /**
         * <p>
         * The unique identifier for the data set associated with this import job.
         * </p>
         * 
         * @param dataSetId
         *        The unique identifier for the data set associated with this import job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSetId(String dataSetId);

        /**
         * <p>
         * The unique identifier for the revision associated with this import request.
         * </p>
         * 
         * @param revisionId
         *        The unique identifier for the revision associated with this import request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder revisionId(String revisionId);
    }

    static final class BuilderImpl implements Builder {
        private List<AssetSourceEntry> assetSources = DefaultSdkAutoConstructList.getInstance();

        private String dataSetId;

        private String revisionId;

        private BuilderImpl() {
        }

        private BuilderImpl(ImportAssetsFromS3RequestDetails model) {
            assetSources(model.assetSources);
            dataSetId(model.dataSetId);
            revisionId(model.revisionId);
        }

        public final Collection<AssetSourceEntry.Builder> getAssetSources() {
            if (assetSources instanceof SdkAutoConstructList) {
                return null;
            }
            return assetSources != null ? assetSources.stream().map(AssetSourceEntry::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder assetSources(Collection<AssetSourceEntry> assetSources) {
            this.assetSources = ListOfAssetSourceEntryCopier.copy(assetSources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assetSources(AssetSourceEntry... assetSources) {
            assetSources(Arrays.asList(assetSources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assetSources(Consumer<AssetSourceEntry.Builder>... assetSources) {
            assetSources(Stream.of(assetSources).map(c -> AssetSourceEntry.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setAssetSources(Collection<AssetSourceEntry.BuilderImpl> assetSources) {
            this.assetSources = ListOfAssetSourceEntryCopier.copyFromBuilder(assetSources);
        }

        public final String getDataSetId() {
            return dataSetId;
        }

        @Override
        public final Builder dataSetId(String dataSetId) {
            this.dataSetId = dataSetId;
            return this;
        }

        public final void setDataSetId(String dataSetId) {
            this.dataSetId = dataSetId;
        }

        public final String getRevisionId() {
            return revisionId;
        }

        @Override
        public final Builder revisionId(String revisionId) {
            this.revisionId = revisionId;
            return this;
        }

        public final void setRevisionId(String revisionId) {
            this.revisionId = revisionId;
        }

        @Override
        public ImportAssetsFromS3RequestDetails build() {
            return new ImportAssetsFromS3RequestDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
