/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dataexchange.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Encryption configuration of the export job. Includes the encryption type as well as the AWS KMS key. The KMS key is
 * only necessary if you chose the KMS encryption type.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ExportServerSideEncryption implements SdkPojo, Serializable,
        ToCopyableBuilder<ExportServerSideEncryption.Builder, ExportServerSideEncryption> {
    private static final SdkField<String> KMS_KEY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KmsKeyArn").getter(getter(ExportServerSideEncryption::kmsKeyArn)).setter(setter(Builder::kmsKeyArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyArn").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(ExportServerSideEncryption::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(KMS_KEY_ARN_FIELD, TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String kmsKeyArn;

    private final String type;

    private ExportServerSideEncryption(BuilderImpl builder) {
        this.kmsKeyArn = builder.kmsKeyArn;
        this.type = builder.type;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the the AWS KMS key you want to use to encrypt the Amazon S3 objects. This
     * parameter is required if you choose aws:kms as an encryption type.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the the AWS KMS key you want to use to encrypt the Amazon S3 objects.
     *         This parameter is required if you choose aws:kms as an encryption type.
     */
    public final String kmsKeyArn() {
        return kmsKeyArn;
    }

    /**
     * <p>
     * The type of server side encryption used for encrypting the objects in Amazon S3.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ServerSideEncryptionTypes#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of server side encryption used for encrypting the objects in Amazon S3.
     * @see ServerSideEncryptionTypes
     */
    public final ServerSideEncryptionTypes type() {
        return ServerSideEncryptionTypes.fromValue(type);
    }

    /**
     * <p>
     * The type of server side encryption used for encrypting the objects in Amazon S3.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ServerSideEncryptionTypes#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of server side encryption used for encrypting the objects in Amazon S3.
     * @see ServerSideEncryptionTypes
     */
    public final String typeAsString() {
        return type;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyArn());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExportServerSideEncryption)) {
            return false;
        }
        ExportServerSideEncryption other = (ExportServerSideEncryption) obj;
        return Objects.equals(kmsKeyArn(), other.kmsKeyArn()) && Objects.equals(typeAsString(), other.typeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ExportServerSideEncryption").add("KmsKeyArn", kmsKeyArn()).add("Type", typeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "KmsKeyArn":
            return Optional.ofNullable(clazz.cast(kmsKeyArn()));
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ExportServerSideEncryption, T> g) {
        return obj -> g.apply((ExportServerSideEncryption) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ExportServerSideEncryption> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the the AWS KMS key you want to use to encrypt the Amazon S3 objects. This
         * parameter is required if you choose aws:kms as an encryption type.
         * </p>
         * 
         * @param kmsKeyArn
         *        The Amazon Resource Name (ARN) of the the AWS KMS key you want to use to encrypt the Amazon S3
         *        objects. This parameter is required if you choose aws:kms as an encryption type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyArn(String kmsKeyArn);

        /**
         * <p>
         * The type of server side encryption used for encrypting the objects in Amazon S3.
         * </p>
         * 
         * @param type
         *        The type of server side encryption used for encrypting the objects in Amazon S3.
         * @see ServerSideEncryptionTypes
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ServerSideEncryptionTypes
         */
        Builder type(String type);

        /**
         * <p>
         * The type of server side encryption used for encrypting the objects in Amazon S3.
         * </p>
         * 
         * @param type
         *        The type of server side encryption used for encrypting the objects in Amazon S3.
         * @see ServerSideEncryptionTypes
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ServerSideEncryptionTypes
         */
        Builder type(ServerSideEncryptionTypes type);
    }

    static final class BuilderImpl implements Builder {
        private String kmsKeyArn;

        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(ExportServerSideEncryption model) {
            kmsKeyArn(model.kmsKeyArn);
            type(model.type);
        }

        public final String getKmsKeyArn() {
            return kmsKeyArn;
        }

        @Override
        public final Builder kmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
            return this;
        }

        public final void setKmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
        }

        public final String getType() {
            return type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(ServerSideEncryptionTypes type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public ExportServerSideEncryption build() {
            return new ExportServerSideEncryption(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
