/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dataexchange.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.dataexchange.model.DataExchangeResponse;
import software.amazon.awssdk.services.dataexchange.model.MapOf__stringCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateRevisionResponse
extends DataExchangeResponse
implements ToCopyableBuilder<Builder, CreateRevisionResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(CreateRevisionResponse.getter(CreateRevisionResponse::arn)).setter(CreateRevisionResponse.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<String> COMMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Comment").getter(CreateRevisionResponse.getter(CreateRevisionResponse::comment)).setter(CreateRevisionResponse.setter(Builder::comment)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Comment").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedAt").getter(CreateRevisionResponse.getter(CreateRevisionResponse::createdAt)).setter(CreateRevisionResponse.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> DATA_SET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DataSetId").getter(CreateRevisionResponse.getter(CreateRevisionResponse::dataSetId)).setter(CreateRevisionResponse.setter(Builder::dataSetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSetId").build()}).build();
    private static final SdkField<Boolean> FINALIZED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Finalized").getter(CreateRevisionResponse.getter(CreateRevisionResponse::finalized)).setter(CreateRevisionResponse.setter(Builder::finalized)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Finalized").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(CreateRevisionResponse.getter(CreateRevisionResponse::id)).setter(CreateRevisionResponse.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<String> SOURCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourceId").getter(CreateRevisionResponse.getter(CreateRevisionResponse::sourceId)).setter(CreateRevisionResponse.setter(Builder::sourceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceId").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(CreateRevisionResponse.getter(CreateRevisionResponse::tags)).setter(CreateRevisionResponse.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("UpdatedAt").getter(CreateRevisionResponse.getter(CreateRevisionResponse::updatedAt)).setter(CreateRevisionResponse.setter(Builder::updatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdatedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, COMMENT_FIELD, CREATED_AT_FIELD, DATA_SET_ID_FIELD, FINALIZED_FIELD, ID_FIELD, SOURCE_ID_FIELD, TAGS_FIELD, UPDATED_AT_FIELD));
    private final String arn;
    private final String comment;
    private final Instant createdAt;
    private final String dataSetId;
    private final Boolean finalized;
    private final String id;
    private final String sourceId;
    private final Map<String, String> tags;
    private final Instant updatedAt;

    private CreateRevisionResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.comment = builder.comment;
        this.createdAt = builder.createdAt;
        this.dataSetId = builder.dataSetId;
        this.finalized = builder.finalized;
        this.id = builder.id;
        this.sourceId = builder.sourceId;
        this.tags = builder.tags;
        this.updatedAt = builder.updatedAt;
    }

    public String arn() {
        return this.arn;
    }

    public String comment() {
        return this.comment;
    }

    public Instant createdAt() {
        return this.createdAt;
    }

    public String dataSetId() {
        return this.dataSetId;
    }

    public Boolean finalized() {
        return this.finalized;
    }

    public String id() {
        return this.id;
    }

    public String sourceId() {
        return this.sourceId;
    }

    public boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public Map<String, String> tags() {
        return this.tags;
    }

    public Instant updatedAt() {
        return this.updatedAt;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.comment());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataSetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.finalized());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.tags());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedAt());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateRevisionResponse)) {
            return false;
        }
        CreateRevisionResponse other = (CreateRevisionResponse)((Object)obj);
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.comment(), other.comment()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.dataSetId(), other.dataSetId()) && Objects.equals(this.finalized(), other.finalized()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.sourceId(), other.sourceId()) && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.updatedAt(), other.updatedAt());
    }

    public String toString() {
        return ToString.builder((String)"CreateRevisionResponse").add("Arn", (Object)this.arn()).add("Comment", (Object)this.comment()).add("CreatedAt", (Object)this.createdAt()).add("DataSetId", (Object)this.dataSetId()).add("Finalized", (Object)this.finalized()).add("Id", (Object)this.id()).add("SourceId", (Object)this.sourceId()).add("Tags", this.tags()).add("UpdatedAt", (Object)this.updatedAt()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "Comment": {
                return Optional.ofNullable(clazz.cast(this.comment()));
            }
            case "CreatedAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "DataSetId": {
                return Optional.ofNullable(clazz.cast(this.dataSetId()));
            }
            case "Finalized": {
                return Optional.ofNullable(clazz.cast(this.finalized()));
            }
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "SourceId": {
                return Optional.ofNullable(clazz.cast(this.sourceId()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "UpdatedAt": {
                return Optional.ofNullable(clazz.cast(this.updatedAt()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateRevisionResponse, T> g) {
        return obj -> g.apply((CreateRevisionResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DataExchangeResponse.BuilderImpl
    implements Builder {
        private String arn;
        private String comment;
        private Instant createdAt;
        private String dataSetId;
        private Boolean finalized;
        private String id;
        private String sourceId;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private Instant updatedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateRevisionResponse model) {
            super(model);
            this.arn(model.arn);
            this.comment(model.comment);
            this.createdAt(model.createdAt);
            this.dataSetId(model.dataSetId);
            this.finalized(model.finalized);
            this.id(model.id);
            this.sourceId(model.sourceId);
            this.tags(model.tags);
            this.updatedAt(model.updatedAt);
        }

        public final String getArn() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getComment() {
            return this.comment;
        }

        @Override
        public final Builder comment(String comment) {
            this.comment = comment;
            return this;
        }

        public final void setComment(String comment) {
            this.comment = comment;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        public final String getDataSetId() {
            return this.dataSetId;
        }

        @Override
        public final Builder dataSetId(String dataSetId) {
            this.dataSetId = dataSetId;
            return this;
        }

        public final void setDataSetId(String dataSetId) {
            this.dataSetId = dataSetId;
        }

        public final Boolean getFinalized() {
            return this.finalized;
        }

        @Override
        public final Builder finalized(Boolean finalized) {
            this.finalized = finalized;
            return this;
        }

        public final void setFinalized(Boolean finalized) {
            this.finalized = finalized;
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getSourceId() {
            return this.sourceId;
        }

        @Override
        public final Builder sourceId(String sourceId) {
            this.sourceId = sourceId;
            return this;
        }

        public final void setSourceId(String sourceId) {
            this.sourceId = sourceId;
        }

        public final Map<String, String> getTags() {
            return this.tags;
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = MapOf__stringCopier.copy(tags);
            return this;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = MapOf__stringCopier.copy(tags);
        }

        public final Instant getUpdatedAt() {
            return this.updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public CreateRevisionResponse build() {
            return new CreateRevisionResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends DataExchangeResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateRevisionResponse> {
        public Builder arn(String var1);

        public Builder comment(String var1);

        public Builder createdAt(Instant var1);

        public Builder dataSetId(String var1);

        public Builder finalized(Boolean var1);

        public Builder id(String var1);

        public Builder sourceId(String var1);

        public Builder tags(Map<String, String> var1);

        public Builder updatedAt(Instant var1);
    }
}

