/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dataexchange.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.exception.AwsErrorDetails;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The request has exceeded the quotas imposed by the service.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ServiceLimitExceededException extends DataExchangeException implements
        ToCopyableBuilder<ServiceLimitExceededException.Builder, ServiceLimitExceededException> {
    private static final SdkField<String> LIMIT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ServiceLimitExceededException::limitNameAsString)).setter(setter(Builder::limitName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LimitName").build()).build();

    private static final SdkField<Double> LIMIT_VALUE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .getter(getter(ServiceLimitExceededException::limitValue)).setter(setter(Builder::limitValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LimitValue").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LIMIT_NAME_FIELD,
            LIMIT_VALUE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String limitName;

    private final Double limitValue;

    private ServiceLimitExceededException(BuilderImpl builder) {
        super(builder);
        this.limitName = builder.limitName;
        this.limitValue = builder.limitValue;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    /**
     * <p>
     * The name of the quota that was exceeded.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #limitName} will
     * return {@link LimitName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #limitNameAsString}.
     * </p>
     * 
     * @return The name of the quota that was exceeded.
     * @see LimitName
     */
    public LimitName limitName() {
        return LimitName.fromValue(limitName);
    }

    /**
     * <p>
     * The name of the quota that was exceeded.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #limitName} will
     * return {@link LimitName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #limitNameAsString}.
     * </p>
     * 
     * @return The name of the quota that was exceeded.
     * @see LimitName
     */
    public String limitNameAsString() {
        return limitName;
    }

    /**
     * <p>
     * The maximum value for the service-specific limit.
     * </p>
     * 
     * @return The maximum value for the service-specific limit.
     */
    public Double limitValue() {
        return limitValue;
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ServiceLimitExceededException, T> g) {
        return obj -> g.apply((ServiceLimitExceededException) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ServiceLimitExceededException>,
            DataExchangeException.Builder {
        /**
         * <p>
         * The name of the quota that was exceeded.
         * </p>
         * 
         * @param limitName
         *        The name of the quota that was exceeded.
         * @see LimitName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LimitName
         */
        Builder limitName(String limitName);

        /**
         * <p>
         * The name of the quota that was exceeded.
         * </p>
         * 
         * @param limitName
         *        The name of the quota that was exceeded.
         * @see LimitName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LimitName
         */
        Builder limitName(LimitName limitName);

        /**
         * <p>
         * The maximum value for the service-specific limit.
         * </p>
         * 
         * @param limitValue
         *        The maximum value for the service-specific limit.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder limitValue(Double limitValue);

        @Override
        Builder awsErrorDetails(AwsErrorDetails awsErrorDetails);

        @Override
        Builder message(String message);

        @Override
        Builder requestId(String requestId);

        @Override
        Builder statusCode(int statusCode);

        @Override
        Builder cause(Throwable cause);
    }

    static final class BuilderImpl extends DataExchangeException.BuilderImpl implements Builder {
        private String limitName;

        private Double limitValue;

        private BuilderImpl() {
        }

        private BuilderImpl(ServiceLimitExceededException model) {
            super(model);
            limitName(model.limitName);
            limitValue(model.limitValue);
        }

        public final String getLimitName() {
            return limitName;
        }

        @Override
        public final Builder limitName(String limitName) {
            this.limitName = limitName;
            return this;
        }

        @Override
        public final Builder limitName(LimitName limitName) {
            this.limitName(limitName == null ? null : limitName.toString());
            return this;
        }

        public final void setLimitName(String limitName) {
            this.limitName = limitName;
        }

        public final Double getLimitValue() {
            return limitValue;
        }

        @Override
        public final Builder limitValue(Double limitValue) {
            this.limitValue = limitValue;
            return this;
        }

        public final void setLimitValue(Double limitValue) {
            this.limitValue = limitValue;
        }

        @Override
        public BuilderImpl awsErrorDetails(AwsErrorDetails awsErrorDetails) {
            this.awsErrorDetails = awsErrorDetails;
            return this;
        }

        @Override
        public BuilderImpl message(String message) {
            this.message = message;
            return this;
        }

        @Override
        public BuilderImpl requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        @Override
        public BuilderImpl statusCode(int statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        @Override
        public BuilderImpl cause(Throwable cause) {
            this.cause = cause;
            return this;
        }

        @Override
        public ServiceLimitExceededException build() {
            return new ServiceLimitExceededException(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
