/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dataexchange.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The request body for CreateJob.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateJobRequest extends DataExchangeRequest implements
        ToCopyableBuilder<CreateJobRequest.Builder, CreateJobRequest> {
    private static final SdkField<RequestDetails> DETAILS_FIELD = SdkField.<RequestDetails> builder(MarshallingType.SDK_POJO)
            .getter(getter(CreateJobRequest::details)).setter(setter(Builder::details)).constructor(RequestDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Details").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateJobRequest::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DETAILS_FIELD, TYPE_FIELD));

    private final RequestDetails details;

    private final String type;

    private CreateJobRequest(BuilderImpl builder) {
        super(builder);
        this.details = builder.details;
        this.type = builder.type;
    }

    /**
     * <p>
     * The details for the CreateJob request.
     * </p>
     * 
     * @return The details for the CreateJob request.
     */
    public RequestDetails details() {
        return details;
    }

    /**
     * <p>
     * The type of job to be created.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link Type#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of job to be created.
     * @see Type
     */
    public Type type() {
        return Type.fromValue(type);
    }

    /**
     * <p>
     * The type of job to be created.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link Type#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of job to be created.
     * @see Type
     */
    public String typeAsString() {
        return type;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(details());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateJobRequest)) {
            return false;
        }
        CreateJobRequest other = (CreateJobRequest) obj;
        return Objects.equals(details(), other.details()) && Objects.equals(typeAsString(), other.typeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateJobRequest").add("Details", details()).add("Type", typeAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Details":
            return Optional.ofNullable(clazz.cast(details()));
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateJobRequest, T> g) {
        return obj -> g.apply((CreateJobRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DataExchangeRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateJobRequest> {
        /**
         * <p>
         * The details for the CreateJob request.
         * </p>
         * 
         * @param details
         *        The details for the CreateJob request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder details(RequestDetails details);

        /**
         * <p>
         * The details for the CreateJob request.
         * </p>
         * This is a convenience that creates an instance of the {@link RequestDetails.Builder} avoiding the need to
         * create one manually via {@link RequestDetails#builder()}.
         *
         * When the {@link Consumer} completes, {@link RequestDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #details(RequestDetails)}.
         * 
         * @param details
         *        a consumer that will call methods on {@link RequestDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #details(RequestDetails)
         */
        default Builder details(Consumer<RequestDetails.Builder> details) {
            return details(RequestDetails.builder().applyMutation(details).build());
        }

        /**
         * <p>
         * The type of job to be created.
         * </p>
         * 
         * @param type
         *        The type of job to be created.
         * @see Type
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Type
         */
        Builder type(String type);

        /**
         * <p>
         * The type of job to be created.
         * </p>
         * 
         * @param type
         *        The type of job to be created.
         * @see Type
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Type
         */
        Builder type(Type type);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DataExchangeRequest.BuilderImpl implements Builder {
        private RequestDetails details;

        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateJobRequest model) {
            super(model);
            details(model.details);
            type(model.type);
        }

        public final RequestDetails.Builder getDetails() {
            return details != null ? details.toBuilder() : null;
        }

        @Override
        public final Builder details(RequestDetails details) {
            this.details = details;
            return this;
        }

        public final void setDetails(RequestDetails.BuilderImpl details) {
            this.details = details != null ? details.build() : null;
        }

        public final String getTypeAsString() {
            return type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(Type type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateJobRequest build() {
            return new CreateJobRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
