/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.databasemigration.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a subnet group in response to a request by the <code>DescribeReplicationSubnetGroups</code> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ReplicationSubnetGroup implements SdkPojo, Serializable,
        ToCopyableBuilder<ReplicationSubnetGroup.Builder, ReplicationSubnetGroup> {
    private static final SdkField<String> REPLICATION_SUBNET_GROUP_IDENTIFIER_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ReplicationSubnetGroupIdentifier")
            .getter(getter(ReplicationSubnetGroup::replicationSubnetGroupIdentifier))
            .setter(setter(Builder::replicationSubnetGroupIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicationSubnetGroupIdentifier")
                    .build()).build();

    private static final SdkField<String> REPLICATION_SUBNET_GROUP_DESCRIPTION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ReplicationSubnetGroupDescription")
            .getter(getter(ReplicationSubnetGroup::replicationSubnetGroupDescription))
            .setter(setter(Builder::replicationSubnetGroupDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicationSubnetGroupDescription")
                    .build()).build();

    private static final SdkField<String> VPC_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("VpcId")
            .getter(getter(ReplicationSubnetGroup::vpcId)).setter(setter(Builder::vpcId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcId").build()).build();

    private static final SdkField<String> SUBNET_GROUP_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SubnetGroupStatus").getter(getter(ReplicationSubnetGroup::subnetGroupStatus))
            .setter(setter(Builder::subnetGroupStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetGroupStatus").build()).build();

    private static final SdkField<List<Subnet>> SUBNETS_FIELD = SdkField
            .<List<Subnet>> builder(MarshallingType.LIST)
            .memberName("Subnets")
            .getter(getter(ReplicationSubnetGroup::subnets))
            .setter(setter(Builder::subnets))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Subnets").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Subnet> builder(MarshallingType.SDK_POJO)
                                            .constructor(Subnet::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> SUPPORTED_NETWORK_TYPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SupportedNetworkTypes")
            .getter(getter(ReplicationSubnetGroup::supportedNetworkTypes))
            .setter(setter(Builder::supportedNetworkTypes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportedNetworkTypes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> IS_READ_ONLY_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("IsReadOnly").getter(getter(ReplicationSubnetGroup::isReadOnly)).setter(setter(Builder::isReadOnly))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsReadOnly").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            REPLICATION_SUBNET_GROUP_IDENTIFIER_FIELD, REPLICATION_SUBNET_GROUP_DESCRIPTION_FIELD, VPC_ID_FIELD,
            SUBNET_GROUP_STATUS_FIELD, SUBNETS_FIELD, SUPPORTED_NETWORK_TYPES_FIELD, IS_READ_ONLY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String replicationSubnetGroupIdentifier;

    private final String replicationSubnetGroupDescription;

    private final String vpcId;

    private final String subnetGroupStatus;

    private final List<Subnet> subnets;

    private final List<String> supportedNetworkTypes;

    private final Boolean isReadOnly;

    private ReplicationSubnetGroup(BuilderImpl builder) {
        this.replicationSubnetGroupIdentifier = builder.replicationSubnetGroupIdentifier;
        this.replicationSubnetGroupDescription = builder.replicationSubnetGroupDescription;
        this.vpcId = builder.vpcId;
        this.subnetGroupStatus = builder.subnetGroupStatus;
        this.subnets = builder.subnets;
        this.supportedNetworkTypes = builder.supportedNetworkTypes;
        this.isReadOnly = builder.isReadOnly;
    }

    /**
     * <p>
     * The identifier of the replication instance subnet group.
     * </p>
     * 
     * @return The identifier of the replication instance subnet group.
     */
    public final String replicationSubnetGroupIdentifier() {
        return replicationSubnetGroupIdentifier;
    }

    /**
     * <p>
     * A description for the replication subnet group.
     * </p>
     * 
     * @return A description for the replication subnet group.
     */
    public final String replicationSubnetGroupDescription() {
        return replicationSubnetGroupDescription;
    }

    /**
     * <p>
     * The ID of the VPC.
     * </p>
     * 
     * @return The ID of the VPC.
     */
    public final String vpcId() {
        return vpcId;
    }

    /**
     * <p>
     * The status of the subnet group.
     * </p>
     * 
     * @return The status of the subnet group.
     */
    public final String subnetGroupStatus() {
        return subnetGroupStatus;
    }

    /**
     * For responses, this returns true if the service returned a value for the Subnets property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasSubnets() {
        return subnets != null && !(subnets instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The subnets that are in the subnet group.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSubnets} method.
     * </p>
     * 
     * @return The subnets that are in the subnet group.
     */
    public final List<Subnet> subnets() {
        return subnets;
    }

    /**
     * For responses, this returns true if the service returned a value for the SupportedNetworkTypes property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasSupportedNetworkTypes() {
        return supportedNetworkTypes != null && !(supportedNetworkTypes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The IP addressing protocol supported by the subnet group. This is used by a replication instance with values such
     * as IPv4 only or Dual-stack that supports both IPv4 and IPv6 addressing. IPv6 only is not yet supported.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSupportedNetworkTypes} method.
     * </p>
     * 
     * @return The IP addressing protocol supported by the subnet group. This is used by a replication instance with
     *         values such as IPv4 only or Dual-stack that supports both IPv4 and IPv6 addressing. IPv6 only is not yet
     *         supported.
     */
    public final List<String> supportedNetworkTypes() {
        return supportedNetworkTypes;
    }

    /**
     * <p>
     * Indicates whether the replication subnet group is read-only. When set to <code>true</code>, this subnet group is
     * managed by DMS as part of a zero-ETL integration and cannot be modified or deleted directly. You can only modify
     * or delete read-only subnet groups through their associated zero-ETL integration.
     * </p>
     * 
     * @return Indicates whether the replication subnet group is read-only. When set to <code>true</code>, this subnet
     *         group is managed by DMS as part of a zero-ETL integration and cannot be modified or deleted directly. You
     *         can only modify or delete read-only subnet groups through their associated zero-ETL integration.
     */
    public final Boolean isReadOnly() {
        return isReadOnly;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(replicationSubnetGroupIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(replicationSubnetGroupDescription());
        hashCode = 31 * hashCode + Objects.hashCode(vpcId());
        hashCode = 31 * hashCode + Objects.hashCode(subnetGroupStatus());
        hashCode = 31 * hashCode + Objects.hashCode(hasSubnets() ? subnets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasSupportedNetworkTypes() ? supportedNetworkTypes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(isReadOnly());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReplicationSubnetGroup)) {
            return false;
        }
        ReplicationSubnetGroup other = (ReplicationSubnetGroup) obj;
        return Objects.equals(replicationSubnetGroupIdentifier(), other.replicationSubnetGroupIdentifier())
                && Objects.equals(replicationSubnetGroupDescription(), other.replicationSubnetGroupDescription())
                && Objects.equals(vpcId(), other.vpcId()) && Objects.equals(subnetGroupStatus(), other.subnetGroupStatus())
                && hasSubnets() == other.hasSubnets() && Objects.equals(subnets(), other.subnets())
                && hasSupportedNetworkTypes() == other.hasSupportedNetworkTypes()
                && Objects.equals(supportedNetworkTypes(), other.supportedNetworkTypes())
                && Objects.equals(isReadOnly(), other.isReadOnly());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ReplicationSubnetGroup")
                .add("ReplicationSubnetGroupIdentifier", replicationSubnetGroupIdentifier())
                .add("ReplicationSubnetGroupDescription", replicationSubnetGroupDescription()).add("VpcId", vpcId())
                .add("SubnetGroupStatus", subnetGroupStatus()).add("Subnets", hasSubnets() ? subnets() : null)
                .add("SupportedNetworkTypes", hasSupportedNetworkTypes() ? supportedNetworkTypes() : null)
                .add("IsReadOnly", isReadOnly()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ReplicationSubnetGroupIdentifier":
            return Optional.ofNullable(clazz.cast(replicationSubnetGroupIdentifier()));
        case "ReplicationSubnetGroupDescription":
            return Optional.ofNullable(clazz.cast(replicationSubnetGroupDescription()));
        case "VpcId":
            return Optional.ofNullable(clazz.cast(vpcId()));
        case "SubnetGroupStatus":
            return Optional.ofNullable(clazz.cast(subnetGroupStatus()));
        case "Subnets":
            return Optional.ofNullable(clazz.cast(subnets()));
        case "SupportedNetworkTypes":
            return Optional.ofNullable(clazz.cast(supportedNetworkTypes()));
        case "IsReadOnly":
            return Optional.ofNullable(clazz.cast(isReadOnly()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ReplicationSubnetGroupIdentifier", REPLICATION_SUBNET_GROUP_IDENTIFIER_FIELD);
        map.put("ReplicationSubnetGroupDescription", REPLICATION_SUBNET_GROUP_DESCRIPTION_FIELD);
        map.put("VpcId", VPC_ID_FIELD);
        map.put("SubnetGroupStatus", SUBNET_GROUP_STATUS_FIELD);
        map.put("Subnets", SUBNETS_FIELD);
        map.put("SupportedNetworkTypes", SUPPORTED_NETWORK_TYPES_FIELD);
        map.put("IsReadOnly", IS_READ_ONLY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ReplicationSubnetGroup, T> g) {
        return obj -> g.apply((ReplicationSubnetGroup) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ReplicationSubnetGroup> {
        /**
         * <p>
         * The identifier of the replication instance subnet group.
         * </p>
         * 
         * @param replicationSubnetGroupIdentifier
         *        The identifier of the replication instance subnet group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicationSubnetGroupIdentifier(String replicationSubnetGroupIdentifier);

        /**
         * <p>
         * A description for the replication subnet group.
         * </p>
         * 
         * @param replicationSubnetGroupDescription
         *        A description for the replication subnet group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicationSubnetGroupDescription(String replicationSubnetGroupDescription);

        /**
         * <p>
         * The ID of the VPC.
         * </p>
         * 
         * @param vpcId
         *        The ID of the VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcId(String vpcId);

        /**
         * <p>
         * The status of the subnet group.
         * </p>
         * 
         * @param subnetGroupStatus
         *        The status of the subnet group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetGroupStatus(String subnetGroupStatus);

        /**
         * <p>
         * The subnets that are in the subnet group.
         * </p>
         * 
         * @param subnets
         *        The subnets that are in the subnet group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnets(Collection<Subnet> subnets);

        /**
         * <p>
         * The subnets that are in the subnet group.
         * </p>
         * 
         * @param subnets
         *        The subnets that are in the subnet group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnets(Subnet... subnets);

        /**
         * <p>
         * The subnets that are in the subnet group.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.databasemigration.model.Subnet.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.databasemigration.model.Subnet#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.databasemigration.model.Subnet.Builder#build()} is called immediately
         * and its result is passed to {@link #subnets(List<Subnet>)}.
         * 
         * @param subnets
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.databasemigration.model.Subnet.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #subnets(java.util.Collection<Subnet>)
         */
        Builder subnets(Consumer<Subnet.Builder>... subnets);

        /**
         * <p>
         * The IP addressing protocol supported by the subnet group. This is used by a replication instance with values
         * such as IPv4 only or Dual-stack that supports both IPv4 and IPv6 addressing. IPv6 only is not yet supported.
         * </p>
         * 
         * @param supportedNetworkTypes
         *        The IP addressing protocol supported by the subnet group. This is used by a replication instance with
         *        values such as IPv4 only or Dual-stack that supports both IPv4 and IPv6 addressing. IPv6 only is not
         *        yet supported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedNetworkTypes(Collection<String> supportedNetworkTypes);

        /**
         * <p>
         * The IP addressing protocol supported by the subnet group. This is used by a replication instance with values
         * such as IPv4 only or Dual-stack that supports both IPv4 and IPv6 addressing. IPv6 only is not yet supported.
         * </p>
         * 
         * @param supportedNetworkTypes
         *        The IP addressing protocol supported by the subnet group. This is used by a replication instance with
         *        values such as IPv4 only or Dual-stack that supports both IPv4 and IPv6 addressing. IPv6 only is not
         *        yet supported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedNetworkTypes(String... supportedNetworkTypes);

        /**
         * <p>
         * Indicates whether the replication subnet group is read-only. When set to <code>true</code>, this subnet group
         * is managed by DMS as part of a zero-ETL integration and cannot be modified or deleted directly. You can only
         * modify or delete read-only subnet groups through their associated zero-ETL integration.
         * </p>
         * 
         * @param isReadOnly
         *        Indicates whether the replication subnet group is read-only. When set to <code>true</code>, this
         *        subnet group is managed by DMS as part of a zero-ETL integration and cannot be modified or deleted
         *        directly. You can only modify or delete read-only subnet groups through their associated zero-ETL
         *        integration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isReadOnly(Boolean isReadOnly);
    }

    static final class BuilderImpl implements Builder {
        private String replicationSubnetGroupIdentifier;

        private String replicationSubnetGroupDescription;

        private String vpcId;

        private String subnetGroupStatus;

        private List<Subnet> subnets = DefaultSdkAutoConstructList.getInstance();

        private List<String> supportedNetworkTypes = DefaultSdkAutoConstructList.getInstance();

        private Boolean isReadOnly;

        private BuilderImpl() {
        }

        private BuilderImpl(ReplicationSubnetGroup model) {
            replicationSubnetGroupIdentifier(model.replicationSubnetGroupIdentifier);
            replicationSubnetGroupDescription(model.replicationSubnetGroupDescription);
            vpcId(model.vpcId);
            subnetGroupStatus(model.subnetGroupStatus);
            subnets(model.subnets);
            supportedNetworkTypes(model.supportedNetworkTypes);
            isReadOnly(model.isReadOnly);
        }

        public final String getReplicationSubnetGroupIdentifier() {
            return replicationSubnetGroupIdentifier;
        }

        public final void setReplicationSubnetGroupIdentifier(String replicationSubnetGroupIdentifier) {
            this.replicationSubnetGroupIdentifier = replicationSubnetGroupIdentifier;
        }

        @Override
        public final Builder replicationSubnetGroupIdentifier(String replicationSubnetGroupIdentifier) {
            this.replicationSubnetGroupIdentifier = replicationSubnetGroupIdentifier;
            return this;
        }

        public final String getReplicationSubnetGroupDescription() {
            return replicationSubnetGroupDescription;
        }

        public final void setReplicationSubnetGroupDescription(String replicationSubnetGroupDescription) {
            this.replicationSubnetGroupDescription = replicationSubnetGroupDescription;
        }

        @Override
        public final Builder replicationSubnetGroupDescription(String replicationSubnetGroupDescription) {
            this.replicationSubnetGroupDescription = replicationSubnetGroupDescription;
            return this;
        }

        public final String getVpcId() {
            return vpcId;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final String getSubnetGroupStatus() {
            return subnetGroupStatus;
        }

        public final void setSubnetGroupStatus(String subnetGroupStatus) {
            this.subnetGroupStatus = subnetGroupStatus;
        }

        @Override
        public final Builder subnetGroupStatus(String subnetGroupStatus) {
            this.subnetGroupStatus = subnetGroupStatus;
            return this;
        }

        public final List<Subnet.Builder> getSubnets() {
            List<Subnet.Builder> result = SubnetListCopier.copyToBuilder(this.subnets);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSubnets(Collection<Subnet.BuilderImpl> subnets) {
            this.subnets = SubnetListCopier.copyFromBuilder(subnets);
        }

        @Override
        public final Builder subnets(Collection<Subnet> subnets) {
            this.subnets = SubnetListCopier.copy(subnets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnets(Subnet... subnets) {
            subnets(Arrays.asList(subnets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnets(Consumer<Subnet.Builder>... subnets) {
            subnets(Stream.of(subnets).map(c -> Subnet.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getSupportedNetworkTypes() {
            if (supportedNetworkTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return supportedNetworkTypes;
        }

        public final void setSupportedNetworkTypes(Collection<String> supportedNetworkTypes) {
            this.supportedNetworkTypes = StringListCopier.copy(supportedNetworkTypes);
        }

        @Override
        public final Builder supportedNetworkTypes(Collection<String> supportedNetworkTypes) {
            this.supportedNetworkTypes = StringListCopier.copy(supportedNetworkTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedNetworkTypes(String... supportedNetworkTypes) {
            supportedNetworkTypes(Arrays.asList(supportedNetworkTypes));
            return this;
        }

        public final Boolean getIsReadOnly() {
            return isReadOnly;
        }

        public final void setIsReadOnly(Boolean isReadOnly) {
            this.isReadOnly = isReadOnly;
        }

        @Override
        public final Builder isReadOnly(Boolean isReadOnly) {
            this.isReadOnly = isReadOnly;
            return this;
        }

        @Override
        public ReplicationSubnetGroup build() {
            return new ReplicationSubnetGroup(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
