/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.databasemigration.model.DatabaseListCopier;
import software.amazon.awssdk.services.databasemigration.model.DatabaseMigrationResponse;
import software.amazon.awssdk.services.databasemigration.model.DatabaseResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeFleetAdvisorDatabasesResponse
extends DatabaseMigrationResponse
implements ToCopyableBuilder<Builder, DescribeFleetAdvisorDatabasesResponse> {
    private static final SdkField<List<DatabaseResponse>> DATABASES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Databases").getter(DescribeFleetAdvisorDatabasesResponse.getter(DescribeFleetAdvisorDatabasesResponse::databases)).setter(DescribeFleetAdvisorDatabasesResponse.setter(Builder::databases)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Databases").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DatabaseResponse::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeFleetAdvisorDatabasesResponse.getter(DescribeFleetAdvisorDatabasesResponse::nextToken)).setter(DescribeFleetAdvisorDatabasesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATABASES_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeFleetAdvisorDatabasesResponse.memberNameToFieldInitializer();
    private final List<DatabaseResponse> databases;
    private final String nextToken;

    private DescribeFleetAdvisorDatabasesResponse(BuilderImpl builder) {
        super(builder);
        this.databases = builder.databases;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasDatabases() {
        return this.databases != null && !(this.databases instanceof SdkAutoConstructList);
    }

    public final List<DatabaseResponse> databases() {
        return this.databases;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDatabases() ? this.databases() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeFleetAdvisorDatabasesResponse)) {
            return false;
        }
        DescribeFleetAdvisorDatabasesResponse other = (DescribeFleetAdvisorDatabasesResponse)((Object)obj);
        return this.hasDatabases() == other.hasDatabases() && Objects.equals(this.databases(), other.databases()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeFleetAdvisorDatabasesResponse").add("Databases", this.hasDatabases() ? this.databases() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Databases": {
                return Optional.ofNullable(clazz.cast(this.databases()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Databases", DATABASES_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeFleetAdvisorDatabasesResponse, T> g) {
        return obj -> g.apply((DescribeFleetAdvisorDatabasesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DatabaseMigrationResponse.BuilderImpl
    implements Builder {
        private List<DatabaseResponse> databases = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeFleetAdvisorDatabasesResponse model) {
            super(model);
            this.databases(model.databases);
            this.nextToken(model.nextToken);
        }

        public final List<DatabaseResponse.Builder> getDatabases() {
            List<DatabaseResponse.Builder> result = DatabaseListCopier.copyToBuilder(this.databases);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDatabases(Collection<DatabaseResponse.BuilderImpl> databases) {
            this.databases = DatabaseListCopier.copyFromBuilder(databases);
        }

        @Override
        public final Builder databases(Collection<DatabaseResponse> databases) {
            this.databases = DatabaseListCopier.copy(databases);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder databases(DatabaseResponse ... databases) {
            this.databases(Arrays.asList(databases));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder databases(Consumer<DatabaseResponse.Builder> ... databases) {
            this.databases(Stream.of(databases).map(c -> (DatabaseResponse)((DatabaseResponse.Builder)DatabaseResponse.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeFleetAdvisorDatabasesResponse build() {
            return new DescribeFleetAdvisorDatabasesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends DatabaseMigrationResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeFleetAdvisorDatabasesResponse> {
        public Builder databases(Collection<DatabaseResponse> var1);

        public Builder databases(DatabaseResponse ... var1);

        public Builder databases(Consumer<DatabaseResponse.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

