/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DmsTransferSettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DmsTransferSettings> {
    private static final SdkField<String> SERVICE_ACCESS_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ServiceAccessRoleArn").getter(DmsTransferSettings.getter(DmsTransferSettings::serviceAccessRoleArn)).setter(DmsTransferSettings.setter(Builder::serviceAccessRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceAccessRoleArn").build()}).build();
    private static final SdkField<String> BUCKET_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BucketName").getter(DmsTransferSettings.getter(DmsTransferSettings::bucketName)).setter(DmsTransferSettings.setter(Builder::bucketName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BucketName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_ACCESS_ROLE_ARN_FIELD, BUCKET_NAME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DmsTransferSettings.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String serviceAccessRoleArn;
    private final String bucketName;

    private DmsTransferSettings(BuilderImpl builder) {
        this.serviceAccessRoleArn = builder.serviceAccessRoleArn;
        this.bucketName = builder.bucketName;
    }

    public final String serviceAccessRoleArn() {
        return this.serviceAccessRoleArn;
    }

    public final String bucketName() {
        return this.bucketName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceAccessRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.bucketName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DmsTransferSettings)) {
            return false;
        }
        DmsTransferSettings other = (DmsTransferSettings)obj;
        return Objects.equals(this.serviceAccessRoleArn(), other.serviceAccessRoleArn()) && Objects.equals(this.bucketName(), other.bucketName());
    }

    public final String toString() {
        return ToString.builder((String)"DmsTransferSettings").add("ServiceAccessRoleArn", (Object)this.serviceAccessRoleArn()).add("BucketName", (Object)this.bucketName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ServiceAccessRoleArn": {
                return Optional.ofNullable(clazz.cast(this.serviceAccessRoleArn()));
            }
            case "BucketName": {
                return Optional.ofNullable(clazz.cast(this.bucketName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("ServiceAccessRoleArn", SERVICE_ACCESS_ROLE_ARN_FIELD);
        map.put("BucketName", BUCKET_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DmsTransferSettings, T> g) {
        return obj -> g.apply((DmsTransferSettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String serviceAccessRoleArn;
        private String bucketName;

        private BuilderImpl() {
        }

        private BuilderImpl(DmsTransferSettings model) {
            this.serviceAccessRoleArn(model.serviceAccessRoleArn);
            this.bucketName(model.bucketName);
        }

        public final String getServiceAccessRoleArn() {
            return this.serviceAccessRoleArn;
        }

        public final void setServiceAccessRoleArn(String serviceAccessRoleArn) {
            this.serviceAccessRoleArn = serviceAccessRoleArn;
        }

        @Override
        public final Builder serviceAccessRoleArn(String serviceAccessRoleArn) {
            this.serviceAccessRoleArn = serviceAccessRoleArn;
            return this;
        }

        public final String getBucketName() {
            return this.bucketName;
        }

        public final void setBucketName(String bucketName) {
            this.bucketName = bucketName;
        }

        @Override
        public final Builder bucketName(String bucketName) {
            this.bucketName = bucketName;
            return this;
        }

        public DmsTransferSettings build() {
            return new DmsTransferSettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DmsTransferSettings> {
        public Builder serviceAccessRoleArn(String var1);

        public Builder bucketName(String var1);
    }
}

