/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.databasemigration.model.CollectorHealthCheck;
import software.amazon.awssdk.services.databasemigration.model.InventoryData;
import software.amazon.awssdk.services.databasemigration.model.VersionStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CollectorResponse
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CollectorResponse> {
    private static final SdkField<String> COLLECTOR_REFERENCED_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CollectorReferencedId").getter(CollectorResponse.getter(CollectorResponse::collectorReferencedId)).setter(CollectorResponse.setter(Builder::collectorReferencedId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CollectorReferencedId").build()}).build();
    private static final SdkField<String> COLLECTOR_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CollectorName").getter(CollectorResponse.getter(CollectorResponse::collectorName)).setter(CollectorResponse.setter(Builder::collectorName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CollectorName").build()}).build();
    private static final SdkField<String> COLLECTOR_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CollectorVersion").getter(CollectorResponse.getter(CollectorResponse::collectorVersion)).setter(CollectorResponse.setter(Builder::collectorVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CollectorVersion").build()}).build();
    private static final SdkField<String> VERSION_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VersionStatus").getter(CollectorResponse.getter(CollectorResponse::versionStatusAsString)).setter(CollectorResponse.setter(Builder::versionStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VersionStatus").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(CollectorResponse.getter(CollectorResponse::description)).setter(CollectorResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> S3_BUCKET_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("S3BucketName").getter(CollectorResponse.getter(CollectorResponse::s3BucketName)).setter(CollectorResponse.setter(Builder::s3BucketName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3BucketName").build()}).build();
    private static final SdkField<String> SERVICE_ACCESS_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ServiceAccessRoleArn").getter(CollectorResponse.getter(CollectorResponse::serviceAccessRoleArn)).setter(CollectorResponse.setter(Builder::serviceAccessRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceAccessRoleArn").build()}).build();
    private static final SdkField<CollectorHealthCheck> COLLECTOR_HEALTH_CHECK_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CollectorHealthCheck").getter(CollectorResponse.getter(CollectorResponse::collectorHealthCheck)).setter(CollectorResponse.setter(Builder::collectorHealthCheck)).constructor(CollectorHealthCheck::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CollectorHealthCheck").build()}).build();
    private static final SdkField<String> LAST_DATA_RECEIVED_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LastDataReceived").getter(CollectorResponse.getter(CollectorResponse::lastDataReceived)).setter(CollectorResponse.setter(Builder::lastDataReceived)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastDataReceived").build()}).build();
    private static final SdkField<String> REGISTERED_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RegisteredDate").getter(CollectorResponse.getter(CollectorResponse::registeredDate)).setter(CollectorResponse.setter(Builder::registeredDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegisteredDate").build()}).build();
    private static final SdkField<String> CREATED_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CreatedDate").getter(CollectorResponse.getter(CollectorResponse::createdDate)).setter(CollectorResponse.setter(Builder::createdDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedDate").build()}).build();
    private static final SdkField<String> MODIFIED_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ModifiedDate").getter(CollectorResponse.getter(CollectorResponse::modifiedDate)).setter(CollectorResponse.setter(Builder::modifiedDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModifiedDate").build()}).build();
    private static final SdkField<InventoryData> INVENTORY_DATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("InventoryData").getter(CollectorResponse.getter(CollectorResponse::inventoryData)).setter(CollectorResponse.setter(Builder::inventoryData)).constructor(InventoryData::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InventoryData").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COLLECTOR_REFERENCED_ID_FIELD, COLLECTOR_NAME_FIELD, COLLECTOR_VERSION_FIELD, VERSION_STATUS_FIELD, DESCRIPTION_FIELD, S3_BUCKET_NAME_FIELD, SERVICE_ACCESS_ROLE_ARN_FIELD, COLLECTOR_HEALTH_CHECK_FIELD, LAST_DATA_RECEIVED_FIELD, REGISTERED_DATE_FIELD, CREATED_DATE_FIELD, MODIFIED_DATE_FIELD, INVENTORY_DATA_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CollectorResponse.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String collectorReferencedId;
    private final String collectorName;
    private final String collectorVersion;
    private final String versionStatus;
    private final String description;
    private final String s3BucketName;
    private final String serviceAccessRoleArn;
    private final CollectorHealthCheck collectorHealthCheck;
    private final String lastDataReceived;
    private final String registeredDate;
    private final String createdDate;
    private final String modifiedDate;
    private final InventoryData inventoryData;

    private CollectorResponse(BuilderImpl builder) {
        this.collectorReferencedId = builder.collectorReferencedId;
        this.collectorName = builder.collectorName;
        this.collectorVersion = builder.collectorVersion;
        this.versionStatus = builder.versionStatus;
        this.description = builder.description;
        this.s3BucketName = builder.s3BucketName;
        this.serviceAccessRoleArn = builder.serviceAccessRoleArn;
        this.collectorHealthCheck = builder.collectorHealthCheck;
        this.lastDataReceived = builder.lastDataReceived;
        this.registeredDate = builder.registeredDate;
        this.createdDate = builder.createdDate;
        this.modifiedDate = builder.modifiedDate;
        this.inventoryData = builder.inventoryData;
    }

    public final String collectorReferencedId() {
        return this.collectorReferencedId;
    }

    public final String collectorName() {
        return this.collectorName;
    }

    public final String collectorVersion() {
        return this.collectorVersion;
    }

    public final VersionStatus versionStatus() {
        return VersionStatus.fromValue(this.versionStatus);
    }

    public final String versionStatusAsString() {
        return this.versionStatus;
    }

    public final String description() {
        return this.description;
    }

    public final String s3BucketName() {
        return this.s3BucketName;
    }

    public final String serviceAccessRoleArn() {
        return this.serviceAccessRoleArn;
    }

    public final CollectorHealthCheck collectorHealthCheck() {
        return this.collectorHealthCheck;
    }

    public final String lastDataReceived() {
        return this.lastDataReceived;
    }

    public final String registeredDate() {
        return this.registeredDate;
    }

    public final String createdDate() {
        return this.createdDate;
    }

    public final String modifiedDate() {
        return this.modifiedDate;
    }

    public final InventoryData inventoryData() {
        return this.inventoryData;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.collectorReferencedId());
        hashCode = 31 * hashCode + Objects.hashCode(this.collectorName());
        hashCode = 31 * hashCode + Objects.hashCode(this.collectorVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.versionStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3BucketName());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceAccessRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.collectorHealthCheck());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastDataReceived());
        hashCode = 31 * hashCode + Objects.hashCode(this.registeredDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.modifiedDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.inventoryData());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CollectorResponse)) {
            return false;
        }
        CollectorResponse other = (CollectorResponse)obj;
        return Objects.equals(this.collectorReferencedId(), other.collectorReferencedId()) && Objects.equals(this.collectorName(), other.collectorName()) && Objects.equals(this.collectorVersion(), other.collectorVersion()) && Objects.equals(this.versionStatusAsString(), other.versionStatusAsString()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.s3BucketName(), other.s3BucketName()) && Objects.equals(this.serviceAccessRoleArn(), other.serviceAccessRoleArn()) && Objects.equals(this.collectorHealthCheck(), other.collectorHealthCheck()) && Objects.equals(this.lastDataReceived(), other.lastDataReceived()) && Objects.equals(this.registeredDate(), other.registeredDate()) && Objects.equals(this.createdDate(), other.createdDate()) && Objects.equals(this.modifiedDate(), other.modifiedDate()) && Objects.equals(this.inventoryData(), other.inventoryData());
    }

    public final String toString() {
        return ToString.builder((String)"CollectorResponse").add("CollectorReferencedId", (Object)this.collectorReferencedId()).add("CollectorName", (Object)this.collectorName()).add("CollectorVersion", (Object)this.collectorVersion()).add("VersionStatus", (Object)this.versionStatusAsString()).add("Description", (Object)this.description()).add("S3BucketName", (Object)this.s3BucketName()).add("ServiceAccessRoleArn", (Object)this.serviceAccessRoleArn()).add("CollectorHealthCheck", (Object)this.collectorHealthCheck()).add("LastDataReceived", (Object)this.lastDataReceived()).add("RegisteredDate", (Object)this.registeredDate()).add("CreatedDate", (Object)this.createdDate()).add("ModifiedDate", (Object)this.modifiedDate()).add("InventoryData", (Object)this.inventoryData()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CollectorReferencedId": {
                return Optional.ofNullable(clazz.cast(this.collectorReferencedId()));
            }
            case "CollectorName": {
                return Optional.ofNullable(clazz.cast(this.collectorName()));
            }
            case "CollectorVersion": {
                return Optional.ofNullable(clazz.cast(this.collectorVersion()));
            }
            case "VersionStatus": {
                return Optional.ofNullable(clazz.cast(this.versionStatusAsString()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "S3BucketName": {
                return Optional.ofNullable(clazz.cast(this.s3BucketName()));
            }
            case "ServiceAccessRoleArn": {
                return Optional.ofNullable(clazz.cast(this.serviceAccessRoleArn()));
            }
            case "CollectorHealthCheck": {
                return Optional.ofNullable(clazz.cast(this.collectorHealthCheck()));
            }
            case "LastDataReceived": {
                return Optional.ofNullable(clazz.cast(this.lastDataReceived()));
            }
            case "RegisteredDate": {
                return Optional.ofNullable(clazz.cast(this.registeredDate()));
            }
            case "CreatedDate": {
                return Optional.ofNullable(clazz.cast(this.createdDate()));
            }
            case "ModifiedDate": {
                return Optional.ofNullable(clazz.cast(this.modifiedDate()));
            }
            case "InventoryData": {
                return Optional.ofNullable(clazz.cast(this.inventoryData()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("CollectorReferencedId", COLLECTOR_REFERENCED_ID_FIELD);
        map.put("CollectorName", COLLECTOR_NAME_FIELD);
        map.put("CollectorVersion", COLLECTOR_VERSION_FIELD);
        map.put("VersionStatus", VERSION_STATUS_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("S3BucketName", S3_BUCKET_NAME_FIELD);
        map.put("ServiceAccessRoleArn", SERVICE_ACCESS_ROLE_ARN_FIELD);
        map.put("CollectorHealthCheck", COLLECTOR_HEALTH_CHECK_FIELD);
        map.put("LastDataReceived", LAST_DATA_RECEIVED_FIELD);
        map.put("RegisteredDate", REGISTERED_DATE_FIELD);
        map.put("CreatedDate", CREATED_DATE_FIELD);
        map.put("ModifiedDate", MODIFIED_DATE_FIELD);
        map.put("InventoryData", INVENTORY_DATA_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CollectorResponse, T> g) {
        return obj -> g.apply((CollectorResponse)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String collectorReferencedId;
        private String collectorName;
        private String collectorVersion;
        private String versionStatus;
        private String description;
        private String s3BucketName;
        private String serviceAccessRoleArn;
        private CollectorHealthCheck collectorHealthCheck;
        private String lastDataReceived;
        private String registeredDate;
        private String createdDate;
        private String modifiedDate;
        private InventoryData inventoryData;

        private BuilderImpl() {
        }

        private BuilderImpl(CollectorResponse model) {
            this.collectorReferencedId(model.collectorReferencedId);
            this.collectorName(model.collectorName);
            this.collectorVersion(model.collectorVersion);
            this.versionStatus(model.versionStatus);
            this.description(model.description);
            this.s3BucketName(model.s3BucketName);
            this.serviceAccessRoleArn(model.serviceAccessRoleArn);
            this.collectorHealthCheck(model.collectorHealthCheck);
            this.lastDataReceived(model.lastDataReceived);
            this.registeredDate(model.registeredDate);
            this.createdDate(model.createdDate);
            this.modifiedDate(model.modifiedDate);
            this.inventoryData(model.inventoryData);
        }

        public final String getCollectorReferencedId() {
            return this.collectorReferencedId;
        }

        public final void setCollectorReferencedId(String collectorReferencedId) {
            this.collectorReferencedId = collectorReferencedId;
        }

        @Override
        public final Builder collectorReferencedId(String collectorReferencedId) {
            this.collectorReferencedId = collectorReferencedId;
            return this;
        }

        public final String getCollectorName() {
            return this.collectorName;
        }

        public final void setCollectorName(String collectorName) {
            this.collectorName = collectorName;
        }

        @Override
        public final Builder collectorName(String collectorName) {
            this.collectorName = collectorName;
            return this;
        }

        public final String getCollectorVersion() {
            return this.collectorVersion;
        }

        public final void setCollectorVersion(String collectorVersion) {
            this.collectorVersion = collectorVersion;
        }

        @Override
        public final Builder collectorVersion(String collectorVersion) {
            this.collectorVersion = collectorVersion;
            return this;
        }

        public final String getVersionStatus() {
            return this.versionStatus;
        }

        public final void setVersionStatus(String versionStatus) {
            this.versionStatus = versionStatus;
        }

        @Override
        public final Builder versionStatus(String versionStatus) {
            this.versionStatus = versionStatus;
            return this;
        }

        @Override
        public final Builder versionStatus(VersionStatus versionStatus) {
            this.versionStatus(versionStatus == null ? null : versionStatus.toString());
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getS3BucketName() {
            return this.s3BucketName;
        }

        public final void setS3BucketName(String s3BucketName) {
            this.s3BucketName = s3BucketName;
        }

        @Override
        public final Builder s3BucketName(String s3BucketName) {
            this.s3BucketName = s3BucketName;
            return this;
        }

        public final String getServiceAccessRoleArn() {
            return this.serviceAccessRoleArn;
        }

        public final void setServiceAccessRoleArn(String serviceAccessRoleArn) {
            this.serviceAccessRoleArn = serviceAccessRoleArn;
        }

        @Override
        public final Builder serviceAccessRoleArn(String serviceAccessRoleArn) {
            this.serviceAccessRoleArn = serviceAccessRoleArn;
            return this;
        }

        public final CollectorHealthCheck.Builder getCollectorHealthCheck() {
            return this.collectorHealthCheck != null ? this.collectorHealthCheck.toBuilder() : null;
        }

        public final void setCollectorHealthCheck(CollectorHealthCheck.BuilderImpl collectorHealthCheck) {
            this.collectorHealthCheck = collectorHealthCheck != null ? collectorHealthCheck.build() : null;
        }

        @Override
        public final Builder collectorHealthCheck(CollectorHealthCheck collectorHealthCheck) {
            this.collectorHealthCheck = collectorHealthCheck;
            return this;
        }

        public final String getLastDataReceived() {
            return this.lastDataReceived;
        }

        public final void setLastDataReceived(String lastDataReceived) {
            this.lastDataReceived = lastDataReceived;
        }

        @Override
        public final Builder lastDataReceived(String lastDataReceived) {
            this.lastDataReceived = lastDataReceived;
            return this;
        }

        public final String getRegisteredDate() {
            return this.registeredDate;
        }

        public final void setRegisteredDate(String registeredDate) {
            this.registeredDate = registeredDate;
        }

        @Override
        public final Builder registeredDate(String registeredDate) {
            this.registeredDate = registeredDate;
            return this;
        }

        public final String getCreatedDate() {
            return this.createdDate;
        }

        public final void setCreatedDate(String createdDate) {
            this.createdDate = createdDate;
        }

        @Override
        public final Builder createdDate(String createdDate) {
            this.createdDate = createdDate;
            return this;
        }

        public final String getModifiedDate() {
            return this.modifiedDate;
        }

        public final void setModifiedDate(String modifiedDate) {
            this.modifiedDate = modifiedDate;
        }

        @Override
        public final Builder modifiedDate(String modifiedDate) {
            this.modifiedDate = modifiedDate;
            return this;
        }

        public final InventoryData.Builder getInventoryData() {
            return this.inventoryData != null ? this.inventoryData.toBuilder() : null;
        }

        public final void setInventoryData(InventoryData.BuilderImpl inventoryData) {
            this.inventoryData = inventoryData != null ? inventoryData.build() : null;
        }

        @Override
        public final Builder inventoryData(InventoryData inventoryData) {
            this.inventoryData = inventoryData;
            return this;
        }

        public CollectorResponse build() {
            return new CollectorResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CollectorResponse> {
        public Builder collectorReferencedId(String var1);

        public Builder collectorName(String var1);

        public Builder collectorVersion(String var1);

        public Builder versionStatus(String var1);

        public Builder versionStatus(VersionStatus var1);

        public Builder description(String var1);

        public Builder s3BucketName(String var1);

        public Builder serviceAccessRoleArn(String var1);

        public Builder collectorHealthCheck(CollectorHealthCheck var1);

        default public Builder collectorHealthCheck(Consumer<CollectorHealthCheck.Builder> collectorHealthCheck) {
            return this.collectorHealthCheck((CollectorHealthCheck)((CollectorHealthCheck.Builder)CollectorHealthCheck.builder().applyMutation(collectorHealthCheck)).build());
        }

        public Builder lastDataReceived(String var1);

        public Builder registeredDate(String var1);

        public Builder createdDate(String var1);

        public Builder modifiedDate(String var1);

        public Builder inventoryData(InventoryData var1);

        default public Builder inventoryData(Consumer<InventoryData.Builder> inventoryData) {
            return this.inventoryData((InventoryData)((InventoryData.Builder)InventoryData.builder().applyMutation(inventoryData)).build());
        }
    }
}

