/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum RedisAuthTypeValue {
    NONE("none"),
    AUTH_ROLE("auth-role"),
    AUTH_TOKEN("auth-token"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, RedisAuthTypeValue> VALUE_MAP;
    private final String value;

    private RedisAuthTypeValue(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static RedisAuthTypeValue fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<RedisAuthTypeValue> knownValues() {
        EnumSet<RedisAuthTypeValue> knownValues = EnumSet.allOf(RedisAuthTypeValue.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(RedisAuthTypeValue.class, RedisAuthTypeValue::toString);
    }
}

